#include <stdlib.h>
#include <iostream.h>
#include "Geometry.h"
#include "MovementObservation.h"
#include "ServerParam.h"
#include "Logger.h"
using namespace spades;

MovementObservation::MovementObservation(void) {
  start = new VecPosition[ServerParam::instance()->getSPTeamSize()];
  end = new VecPosition[ServerParam::instance()->getSPTeamSize()];
  time = 0;
  bm = new BallMovement;
}
  

MovementObservation::MovementObservation(VecPosition* st, VecPosition* ed,
					 int t, BallMovement* ball){
  actionlog(140) << "Creating observation from arguments" << ende;
  int i = 0;
  start = new VecPosition[ServerParam::instance()->getSPTeamSize()];
  end = new VecPosition[ServerParam::instance()->getSPTeamSize()];
  for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
    start[i] = st[i];
    end[i] = ed[i];
  }
  time = t;
  bm = new BallMovement;
  //cout << "new bm's pointer: " << bm << "\n";
  //cout << "old bm's pointer: " << ball << "\n";
  bm->copyFrom(ball);
}

MovementObservation::~MovementObservation(void) {
//    int i = 0;
//    for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
//      delete &start[i];
//      delete &end[i];
//    }
  delete []start;
  delete []end;
  delete bm;
}

BallMovement* MovementObservation::getBallMovement(void) {
  return bm;
}

VecPosition* MovementObservation::getStartLocs(void){
  return start;
}

VecPosition* MovementObservation::getEndLocs(void){
  return end;
}

void MovementObservation::setTime(const int t){
  time = t;
}

void MovementObservation::setBallMovement(BallMovement* ball){
  bm->copyFrom(ball);
}

void MovementObservation::setLocations(VecPosition* st, VecPosition* ed){
  int i = 0;
  for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
    start[i] = st[i];
    end[i] = ed[i];
  }
}

void MovementObservation::setStartLocation(int player, VecPosition pos){
  if (player >= ServerParam::instance()->getSPTeamSize())
    errorlog << "Observation player index  given is out of bound" << ende;
  else { 
    start[player-1] = pos;
  }
}
	
void MovementObservation::setEndLocation(int player, VecPosition pos){
  if (player >= ServerParam::instance()->getSPTeamSize())  
    errorlog << "Observation player index  given is out of bound" << ende;
  else {
    end[player-1] = pos;
  }
}

VecPosition MovementObservation::getStartLocation(int player) {
  return start[player-1];
}

VecPosition MovementObservation::getEndLocation(int player) {
  return end[player-1];
}



void MovementObservation::GenerateFakeEndPos(OppModel *pOM)
{
  PlayerDistribution distInit;
  distInit.setInitial(start);
  PlayerDistribution distFinal;
  pOM->predictMovement(&distInit, &distFinal, bm);
  GenerateFakeEndPos(&distFinal);
}

void MovementObservation::GenerateFakeEndPos(PlayerDistribution* pDist)
{
  for (int i=0; i<ServerParam::instance()->getSPTeamSize(); i++)
    end[i] = pDist->getPlayDist(i+1)->GenerateSample();
}

