#error Do not use GridPlayerDistribution! Use PlayerDistribution

#include<stdlib.h>
#include<iostream.h>
#include<cmath>
#include<cstdlib>

#include <client.h>
#include <utils.h>
#include "GridPlayerDistribution.h"

GridPlayerDistribution::GridPlayerDistribution(void) {
  int i = 0;
  int j = 0;
  int k = 0;


  players = new float**[ServerParam::instance()->getSPTeamSize()];
  for(i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
    players[i] = new float*[(int)std::ceil(ServerParam::instance()->getSPPitchLength()/Mem->CP_OM_grid_cell_height)];
  }
 i = 0;
  for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {  
    for(j = 0; j < (int)std::ceil(ServerParam::instance()->getSPPitchLength()/Mem->CP_OM_grid_cell_height); ++j) {
      players[i][j] = new float[(int)std::ceil(ServerParam::instance()->getSPPitchWidth()/Mem->CP_OM_grid_cell_width)];
    }
  }
  
  i = 0;
  j = 0;
  for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
    for (j = 0; j < (int)std::ceil(ServerParam::instance()->getSPPitchLength()/Mem->CP_OM_grid_cell_height); ++j) {
      for (k = 0; k < (int)std::ceil(ServerParam::instance()->getSPPitchWidth()/Mem->CP_OM_grid_cell_width); ++k) {
	players[i][j][k] = 0.0;
      }
    }
  }
}

GridPlayerDistribution::~GridPlayerDistribution(void) {
  int i = 0;
  int j = 0;
  
  for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
    for (j = 0; j < (int)std::ceil(ServerParam::instance()->getSPPitchLength()/Mem->CP_OM_grid_cell_height); ++j) {
      delete []players[i][j];
    }
  }
  i = 0;
  for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) 
    delete []players[i];
  delete []players;
}

void GridPlayerDistribution::setInitialDistribution(VecPosition* initPos) {
  int i = 0;
  for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
    if ((initPos[i].x >= ServerParam::instance()->getSPPitchLength()) || 
	(initPos[i].y >= ServerParam::instance()->getSPPitchWidth())) { 
      //cout << "detected an error trying to set initd\n";
      my_error("GridPlayerDistribution indices given are out of bound");
    }
    else {
      //cout << i << " , " << (int)std::floor(initPos[i].x/Mem->CP_OM_grid_cell_height) 
      //<< " , " << (int)std::floor(initPos[i].y/Mem->CP_OM_grid_cell_width) << "\n";
      players[i]
	[(int)std::floor((initPos[i].x/Mem->CP_OM_grid_cell_height)+(ServerParam::instance()->getSPPitchLength()/2.0))]
	[(int)std::floor((initPos[i].y/Mem->CP_OM_grid_cell_width)+(ServerParam::instance()->getSPPitchWidth()/2.0))] = 1.0;
    }
  }
  
//    i = 0;
//    int j = 0;
//    int k = 0;
//    for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
//      for (j = 0; j < (int)std::ceil(ServerParam::instance()->getSPPitchLength()/Mem->CP_OM_grid_cell_height); ++j) {
//        for (k = 0; k < (int)std::ceil(ServerParam::instance()->getSPPitchWidth()/Mem->CP_OM_grid_cell_width); ++k) {
//  	if (players[i][j][k] == 1.0) cout << i << " , " << j << " , " << k << "\n";
//        }
//      }
//    }
}

float GridPlayerDistribution::getValue(int player, float x, float y) {
  if ((player >= ServerParam::instance()->getSPTeamSize()) || 
      (x >= ServerParam::instance()->getSPPitchLength()) || 
      (y >= ServerParam::instance()->getSPPitchWidth())) {
    my_error("GridPlayerDistribution indices given are out of bound");
    return -1;
  }
  else { 
    //cout << player << " , " << x << " , " << y << "\n";
    return players[player][(int)std::floor((x/Mem->CP_OM_grid_cell_height)+(ServerParam::instance()->getSPPitchLength()/2.0))]
      [(int)std::floor((y/Mem->CP_OM_grid_cell_width)+(ServerParam::instance()->getSPPitchWidth()/2.0))];
  }
}

void GridPlayerDistribution::clear(void) {
  int i = 0;
  int j = 0;
  int k = 0;
  
  for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
    for (j = 0; j < (int)std::ceil(ServerParam::instance()->getSPPitchLength()/Mem->CP_OM_grid_cell_height); ++j) {
      for (k = 0; k < (int)std::ceil(ServerParam::instance()->getSPPitchWidth()/Mem->CP_OM_grid_cell_width); ++k) {
	players[i][j][k] = 0.0;
      }
    }
  }
}


void GridPlayerDistribution::copyFrom(PlayerDistribution* master) {
  int i = 0;
  int j = 0;
  int k = 0;
  for (i = 0; i < ServerParam::instance()->getSPTeamSize(); ++i) {
    for (j = 0; j < (int)std::ceil(ServerParam::instance()->getSPPitchLength()/Mem->CP_OM_grid_cell_height); ++j) {
      for (k = 0; k < (int)std::ceil(ServerParam::instance()->getSPPitchWidth()/Mem->CP_OM_grid_cell_width); ++k) {
	float temp = (*master).getValue(i, (float)j-(ServerParam::instance()->getSPPitchLength()/2.0), (float)k-(ServerParam::instance()->getSPPitchWidth()/2.0));
  	//if (temp == 1.0) cout << i << " , " << j << " , " << k << "\n";
	players[i][j][k] = temp; 
      }
    }
  }
}








