/* -*- Mode: C++ -*- */

/* this is a base class on which executor inherit */

#ifndef _EXECUTOR_H_	
#define _EXECUTOR_H_ 

#include "ControllerFunction.h"
#include "PlanExecution.h"

enum executor_return_t {
  ER_None,
  ER_Normal,
  ER_Complete, //nothing left for this agent to do
  ER_Error,
  ER_Abort
};



class Executor : public ControllerFunction {
public:
  Executor() : ControllerFunction("Executor") {};  

  virtual executor_return_t run(PlanExecution* plan_exec) = 0;

  virtual void* asynch_worker() = 0;
  
};

#endif 
