/* -*- Mode: C++ -*- */
#ifndef _DEFOPPMODEL_H_
#define _DEFOPPMODEL_H_

#include <stdlib.h>
#include <iostream.h>
#include <cmath>
#include <cstdlib>

#include "soccer_utils.h"
#include "Geometry.h"
#include "Problem.h"

class DefOppModel {

private:

  VecPosition* KIpreviousExits;
  VecPosition* KOpreviousExits;
  VecPosition* GKpreviousExits;
  VecPosition* GCpreviousExits;
  VecPosition* CKpreviousExits;
  VecPosition* FKpreviousExits;
  
  int KIcurrentSize;
  int KOcurrentSize;
  int GCcurrentSize;
  int GKcurrentSize;
  int CKcurrentSize;
  int FKcurrentSize;

  void addLoc(VecPosition* previousExits, VecPosition ball_loc, 
	      VecPosition ball_pos, int* currentSize);
  

public:

  DefOppModel(TeamSide my_side);
  
  virtual ~DefOppModel(void);

  virtual int setDefense(Problem* p, VecPosition* loc);

  virtual bool addInfo(Problem* p, int time, VecPosition ball_loc);
  //time is the time since the ball was last kicked

  TeamSide my_side;
  
};

#endif
