#include <math.h>
#include "DefOppModel.h"
#include "ServerParam.h"
#include "CoachParam.h"
#include "misc.h"
#include "Logger.h"
using namespace spades;

//using namespace std;

#define DEB_MSG(x) 

DefOppModel::DefOppModel(TeamSide my_side)
  : my_side(my_side)
{
  KIpreviousExits = new VecPosition[CoachParam::instance()->getSppOmNumExits()];
  KOpreviousExits = new VecPosition[CoachParam::instance()->getSppOmNumExits()];
  GKpreviousExits = new VecPosition[CoachParam::instance()->getSppOmNumExits()];
  GCpreviousExits = new VecPosition[CoachParam::instance()->getSppOmNumExits()];
  FKpreviousExits = new VecPosition[CoachParam::instance()->getSppOmNumExits()];
  CKpreviousExits = new VecPosition[CoachParam::instance()->getSppOmNumExits()];
  
  VecPosition unrotated = VecPosition(-10, 0);
  VecPosition plus = unrotated.rotate(45);
  VecPosition minus = unrotated.rotate(-45);
  DEB_MSG(cout << plus << minus << "\n");

  KIpreviousExits[0] = plus;
  KIpreviousExits[1] = minus;
  KIcurrentSize = 2;

  FKpreviousExits[0] = plus;
  FKpreviousExits[1] = minus;
  FKcurrentSize = 2;

  KOpreviousExits[1] = VecPosition(-8, 6);
  KOpreviousExits[3] = VecPosition(-8, -6);
  KOpreviousExits[0] = VecPosition(-1, 25);
  KOpreviousExits[2] = VecPosition(-1, -25);
  KOcurrentSize = 4;

  GCpreviousExits[0] = VecPosition(ServerParam::instance()->getSPPitchLength()/2-18, 22);
  GCpreviousExits[2] = VecPosition(ServerParam::instance()->getSPPitchLength()/2-18, -22);
  GCpreviousExits[1] = VecPosition(ServerParam::instance()->getSPPitchLength()/2-18, 8);
  GCpreviousExits[3] = VecPosition(ServerParam::instance()->getSPPitchLength()/2-18, -8);
  GCcurrentSize = 4;
    
  GKpreviousExits[0] = VecPosition(ServerParam::instance()->getSPPitchLength()/2-16, 20);
  GKpreviousExits[1] = VecPosition(ServerParam::instance()->getSPPitchLength()/2-16, -8);
  GKcurrentSize = 2;

  CKpreviousExits[0] = VecPosition(-ServerParam::instance()->getSPPitchLength()/2+22, 24);
  CKcurrentSize = 1;

  my_side = TS_None;
}

DefOppModel::~DefOppModel(void) {
  delete []KOpreviousExits;
  delete []KIpreviousExits;
  delete []GKpreviousExits;
  delete []GCpreviousExits;
  delete []FKpreviousExits;
  delete []CKpreviousExits;
}

int DefOppModel::setDefense(Problem* p, VecPosition* loc) {
  actionlog(100) << "setting Defense" << ende;
  DEB_MSG(cout << "setting defense\n");
  int counter = 0;
  VecPosition initPos = p->ball_pos;
  if (my_side == TS_Right) initPos = -initPos;
  DEB_MSG(cout << "ball is at: " << initPos << "\n");
  float shift = (ServerParam::instance()->getSPPitchLength()/2 + initPos.getX())/2.0;
  float ang  = fabs((initPos - VecPosition(-ServerParam::instance()->getSPPitchLength()/2,0)).getDirection());
  DEB_MSG(cout << "angle: " << ang << "\n");
  float m = 0.0;
  float x = 0.0;
//    if (initPos.getY() < 0) {
//      m = -initPos.getY() / (ServerParam::instance()->getSPPitchLength()/2 - initPos.getX());
//      x = sqrt(100.0/(1+pow(m,2))) + initPos.getX();
//    }
//    else if (initPos.getY() > 0) {
    m = -initPos.getY() / (-(ServerParam::instance()->getSPPitchLength()/2) - initPos.getX());
    x = -sqrt(100.0/(1+pow(m,2))) + initPos.getX();
//   }
  float y = initPos.getY() + m*(x-initPos.getX());
  DEB_MSG(cout << "m: " << m << ", x: " << x << ", y: " << y << "\n");
  //if (my_side == TS_Right) initPos = -initPos;
  switch (p->mode) {
  case SPM_Their_Kick_Off:
    DEB_MSG(cout << "setting defense for kick off\n");
    actionlog(110) << "setting defense for kick off" << ende;
    if ((CoachParam::instance()->getDspNumKoDefinites() > 1) || (CoachParam::instance()->getDspNumKoDefinites() < 0)) {
      errorlog << "can't get " << CoachParam::instance()->getDspNumKoDefinites()
	       << " definite positions, only one available" << ende;
      return -2;
    }
    if (CoachParam::instance()->getDspNumKoDefinites() == 1) {
      loc[counter] = VecPosition(-10, 0);
      ++counter;
    }
    if ((CoachParam::instance()->getDspNumKoExits() != 2) && (CoachParam::instance()->getDspNumKoExits() != 4))
      errorlog << "can only return an even number of kick off positions, not "
	       << CoachParam::instance()->getDspNumKoExits() << ende;
    for (int ko = 0; ko < CoachParam::instance()->getDspNumKoExits()/2; ++ko) {
      loc[counter] = KOpreviousExits[ko];
      ++counter;
      loc[counter] = KOpreviousExits[ko+2];
      ++counter;
    }
    break;
  case SPM_Their_Kick_In:
    DEB_MSG(cout << "setting defense for kick in\n");
    actionlog(110) << "setting defense for kick in" << ende;
    if ((CoachParam::instance()->getDspNumKiDefinites() > 1) || (CoachParam::instance()->getDspNumKiDefinites() < 0)) {
      errorlog << "can't get " << CoachParam::instance()->getDspNumKiDefinites()
	       << " definite positions, only one available"
	       << ende;
      return -2;
    }
    if (CoachParam::instance()->getDspNumKiDefinites() == 1) {
      DEB_MSG(cout << "trying to add definite kick in positions\n");
      if (( x < ServerParam::instance()->getSPPitchLength()/2) && ( x > -ServerParam::instance()->getSPPitchLength()/2) &&
	  ( y < ServerParam::instance()->getSPPitchWidth()/2) && ( y > -ServerParam::instance()->getSPPitchWidth()/2)) {
	loc[counter] = VecPosition(x,y);
	++counter;
      }
    }
    for (int ki = 0; ki < CoachParam::instance()->getDspNumKiExits(); ++ki) {
      DEB_MSG(cout << "trying to add kick in positions\n");
      if (initPos.getY() >= 0) {
	if (( KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getX() + initPos.getX() < ServerParam::instance()->getSPPitchLength()/2) && 
	    ( KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getX() + initPos.getX() > -ServerParam::instance()->getSPPitchLength()/2) &&
	    ( KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getY() + initPos.getY() < ServerParam::instance()->getSPPitchWidth()/2) && 
	    ( KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getY() + initPos.getY() > -ServerParam::instance()->getSPPitchWidth()/2)) {
	  loc[counter].setX(KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getX() + initPos.getX());
	  loc[counter].setY(KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getY() + initPos.getY());
	  ++counter;
	}
      }
      else if (initPos.getY() < 0) {
	if ((KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getX() + p->ball_pos.getX() < ServerParam::instance()->getSPPitchLength()/2) && 
	    (KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getX() + p->ball_pos.getX() > -ServerParam::instance()->getSPPitchLength()/2) &&
	    (-(KIpreviousExits[KIcurrentSize-1-ki].rotate(ang)).getY() + p->ball_pos.getY() < ServerParam::instance()->getSPPitchWidth()/2) && 
	    (-(KIpreviousExits[KIcurrentSize-1-ki].rotate(ang)).getY() + p->ball_pos.getY() > -ServerParam::instance()->getSPPitchWidth()/2)) {
	  loc[counter].setX(KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getX() + initPos.getX());
	  loc[counter].setY(-KIpreviousExits[KIcurrentSize-1-ki].rotate(ang).getY() + initPos.getY());
	  ++counter;
	}
      }
      if ((fabs(ServerParam::instance()->getSPPitchWidth()/2 - loc[counter-1].getY()) < 4) || 
	  (fabs(-ServerParam::instance()->getSPPitchWidth()/2 - loc[counter-1].getY()) < 4)) {
	if (loc[counter-1].getY() > 0) 
	  loc[counter-1].setY(ServerParam::instance()->getSPPitchWidth()/2 -4);
	else if (loc[counter-1].getY() < 0) 
	  loc[counter-1].setY(-ServerParam::instance()->getSPPitchWidth()/2 + 4);
      }
    }
    break;
  case SPM_Their_Corner_Kick:
    DEB_MSG(cout << "setting defense for corner kick\n");
    actionlog(110) << "setting defense for corner kick" << ende;
    if ((CoachParam::instance()->getDspNumCkDefinites() > 4) || (CoachParam::instance()->getDspNumCkDefinites() < 0)) {
      errorlog << "can't get " << CoachParam::instance()->getDspNumCkDefinites()
	       << " definite positions, only one available" << ende;
      return -2;
    }
    if (CoachParam::instance()->getDspNumCkDefinites() >= 1) {
      VecPosition pt1;
      VecPosition pt2;
      if (initPos.getY() > 0) {
	DEB_MSG(cout << "ck 1: y > 0\n");
	pt1 = VecPosition(initPos.getX(), ServerParam::instance()->getSPPitchWidth()/2);
	pt2 = VecPosition(-ServerParam::instance()->getSPPitchLength()/2 + 8, 0.0);
	loc[counter] = VecPosition::getPointInBetween( pt1, pt2, 10.0);
	++counter;
      }
      else if (initPos.getY() < 0) {
	DEB_MSG(cout << "ck 1: y < 0\n");
	pt1 = VecPosition(initPos.getX(), -ServerParam::instance()->getSPPitchWidth()/2);
	pt2 = VecPosition(-ServerParam::instance()->getSPPitchLength()/2 + 8, 0.0);
	loc[counter] = VecPosition::getPointInBetween(pt1, pt2, 10.0);
	++counter;
      }
      DEB_MSG(cout << pt1 << pt2 << loc[counter-1] << "\n");
    }
    if (CoachParam::instance()->getDspNumCkDefinites() >= 2) {
      if (initPos.getY() > 0) {
	DEB_MSG(cout << "y > 0\n");
	loc[counter].setX(-ServerParam::instance()->getSPPitchLength()/2 + 8 + shift);
	loc[counter].setY(9.16);
	++counter;
      }
      else if (initPos.getY() < 0) {
	DEB_MSG(cout << "y < 0\n");
	loc[counter].setX(-ServerParam::instance()->getSPPitchLength()/2 + 8 + shift);
	loc[counter].setY(-9.16);
	++counter;
      }
    }
    if (CoachParam::instance()->getDspNumCkDefinites() >= 3) {
      loc[counter].setX(-ServerParam::instance()->getSPPitchLength()/2 + 18);
      loc[counter].setY(0);
      ++counter;
    }
    if (CoachParam::instance()->getDspNumCkDefinites() >= 4) {
      if (initPos.getY() > 0) {
	DEB_MSG(cout << "y > 0\n");
	loc[counter].setX(-ServerParam::instance()->getSPPitchLength()/2 + 16);
	loc[counter].setY(20.0);
	++counter;
      }
      else if (initPos.getY() < 0) {
	DEB_MSG(cout << "y < 0\n");
	loc[counter].setX(-ServerParam::instance()->getSPPitchLength()/2 + 16);
	loc[counter].setY(-20.0);
	++counter;
      }
    }
    for (int ck = 0; ck < CoachParam::instance()->getDspNumCkExits(); ++ck) {
      if (initPos.getY() >= 0) {
	loc[counter].setX(CKpreviousExits[CKcurrentSize-1-ck].getX() + shift);
	loc[counter].setY(CKpreviousExits[CKcurrentSize-1-ck].getY());
	++counter;
      }
      else if (initPos.getY() < 0) {
	loc[counter].setX(CKpreviousExits[CKcurrentSize-1-ck].getX() + shift);
	loc[counter].setY(-CKpreviousExits[CKcurrentSize-1-ck].getY());
	++counter;
      }
    }
    break;
  case SPM_Their_Goal_Kick:
    DEB_MSG(cout << "setting defense for goal kick\n");
    actionlog(110) << "setting defense for goal kick" << ende;
    if ((CoachParam::instance()->getDspNumGkDefinites() > 1) || (CoachParam::instance()->getDspNumGkDefinites() < 0)) {
      errorlog << "can't get " << CoachParam::instance()->getDspNumGkDefinites()
	       << " definite positions, only one available" << ende;
      return -2;
    }
    if (CoachParam::instance()->getDspNumGkDefinites() == 1) {
      if (initPos.getY() > 0) {
	DEB_MSG(cout << "y > 0\n");
	loc[counter].setX(ServerParam::instance()->getSPPitchLength()/2 - ServerParam::instance()->getSPPenaltyAreaLength());
	loc[counter].setY(9.16);
	++counter;
      }
      else if (initPos.getY() < 0) {
	DEB_MSG(cout << "y < 0\n");
	loc[counter].setX(ServerParam::instance()->getSPPitchLength()/2 - ServerParam::instance()->getSPPenaltyAreaLength());
	loc[counter].setY(-9.16);
	++counter;
      }
    }
    for (int gk = 0; gk < CoachParam::instance()->getDspNumGkExits(); gk++) {
      if (initPos.getY() >= 0) {
      	loc[counter].setX(GKpreviousExits[GKcurrentSize-1-gk].getX());
	loc[counter].setY(GKpreviousExits[GKcurrentSize-1-gk].getY());
	++counter;
      }
      else if (initPos.getY() < 0) {
	loc[counter].setX(GKpreviousExits[GKcurrentSize-1-gk].getX());
	loc[counter].setY(-GKpreviousExits[GKcurrentSize-1-gk].getY());
	++counter;
      }
    }
    break;
  case SPM_Their_Free_Kick:
    DEB_MSG(cout << "setting defense for free kick\n");
    actionlog(110) << "setting defense for free kick" << ende;
    if ((CoachParam::instance()->getDspNumFkDefinites() > 1) || (CoachParam::instance()->getDspNumFkDefinites() < 0)) {
      errorlog << "can't get " << CoachParam::instance()->getDspNumFkDefinites()
	       << " definite positions, only one available" << ende;
      return -2;
    }
    if (CoachParam::instance()->getDspNumFkDefinites() == 1) {
      if (( x < ServerParam::instance()->getSPPitchLength()/2) && ( x > -ServerParam::instance()->getSPPitchLength()/2) &&
	  ( y < ServerParam::instance()->getSPPitchWidth()/2) && ( y > -ServerParam::instance()->getSPPitchWidth()/2)) {
	loc[counter] = VecPosition(x,y);
	++counter;
      }
    }
    for (int fk = 0; fk < CoachParam::instance()->getDspNumFkExits(); ++fk) {
      if (initPos.getY() >= 0) {
	if ((FKpreviousExits[FKcurrentSize-1-fk].rotate(ang).getX() + initPos.getX() < ServerParam::instance()->getSPPitchLength()/2) && 
	    (FKpreviousExits[FKcurrentSize-1-fk].rotate(ang).getX() + initPos.getX() > -ServerParam::instance()->getSPPitchLength()/2) &&
	    (FKpreviousExits[FKcurrentSize-1-fk].rotate(ang).getY() + initPos.getY() < ServerParam::instance()->getSPPitchWidth()/2) && 
	    (FKpreviousExits[FKcurrentSize-1-fk].rotate(ang).getY() + initPos.getY() > -ServerParam::instance()->getSPPitchWidth()/2)) {
	  loc[counter] = FKpreviousExits[FKcurrentSize-1-fk].rotate(ang) + initPos;
	  ++counter;
	}
      }
      else if (initPos.getY() < 0) {
	if ((FKpreviousExits[FKcurrentSize-1-fk].rotate(ang).getX() + initPos.getX() < ServerParam::instance()->getSPPitchLength()/2) && 
	    (FKpreviousExits[FKcurrentSize-1-fk].rotate(ang).getX() + initPos.getX() > -ServerParam::instance()->getSPPitchLength()/2) &&
	    (-(FKpreviousExits[FKcurrentSize-1-fk].rotate(ang)).getY() + initPos.getY() < ServerParam::instance()->getSPPitchWidth()/2) && 
	    (-(FKpreviousExits[FKcurrentSize-1-fk].rotate(ang)).getY() + initPos.getY() > -ServerParam::instance()->getSPPitchWidth()/2)) {
	  loc[counter].setX(FKpreviousExits[FKcurrentSize-1-fk].rotate(ang).getX() + initPos.getX());
	  loc[counter].setY(-(FKpreviousExits[FKcurrentSize-1-fk].rotate(ang)).getY() + initPos.getY());
	  ++counter;
	}
      }
    }
    break;
  case SPM_Their_Goalie_Catch:
    DEB_MSG(cout << "setting defense for goalie catch \n");
    actionlog(110) << "setting defense for goalie catch" << ende;
    if (CoachParam::instance()->getDspNumGcDefinites() != 0) {
      errorlog << "can't get " << CoachParam::instance()->getDspNumGcDefinites()
	       << " definite positions, zero available" << ende;
      return -2;
    }
    if ((CoachParam::instance()->getDspNumGcExits() != 2) && (CoachParam::instance()->getDspNumGcExits() != 4))
      errorlog << "can only return an even number of goalie catch positions, not "
	       << CoachParam::instance()->getDspNumGcExits() << ende;
    for (int gc = 0; gc < CoachParam::instance()->getDspNumGcExits()/2; ++gc) {
      loc[counter] = GCpreviousExits[gc];
      ++counter;
      loc[counter] = GCpreviousExits[gc+2];
      ++counter;
    }
    break;
  default:
    actionlog(120) << "nondefensive set play mode: " <<  p->mode << ende;
    return -1;
    break;
  }

  /* this has to go down here because free kicks can look like off kick ins */
  if (p->spec_mode == SSPM_Their_Kick_In_Off) {
    //let's bring back some extra players
    actionlog(110) << "It's their offensive kick in, so I'm bringing back players" << ende;
    for (int i=0; i<CoachParam::instance()->getDspNumDefKiExtra(); i++) {
      loc[counter] = VecPosition (initPos.getX() - 5, initPos.getY() - signf(initPos.getY())*(15 + 10*i) );
      ++counter;
    }
  } else {
    actionlog(110) << "It's not an offensive kick in: " << p->spec_mode << ende;
  }

  int k = 0;
  if (counter >= 0) {
    DEB_MSG(cout << "suggested defensive positions\n");
    actionlog(120) << "suggested defensive positions" << ende;
    for (k = 0; k < counter; ++k) {
      //    if (k == 0) { 
	if (my_side == TS_Right) {
	  loc[k] = -loc[k];
	}
	//
      DEB_MSG(cout << k + 1 << ": " << loc[k] << "\n");
      actionlog(120) << " " << k+1 << ": " << loc[k] << ende;
    }  
  }
  
  return counter;
}

bool DefOppModel::addInfo(Problem* p, int time, VecPosition ball_loc) {
  bool added = false;
  DEB_MSG(cout << "adding info to defensive opp model: " << time << "\n");
  actionlog(100) << "adding info to defensive opp model: " << ende;
  DEB_MSG(cout << "the ball is at " << ball_loc << "\n");
  DEB_MSG(cout << "the ball started at " << p->ball_pos << "\n");
  if (time <= 100) {
    DEB_MSG(cout << "trying to calculate distance \n");
    float x = (p->ball_pos).getX() - ball_loc.getX();
    float y = (p->ball_pos).getY() - ball_loc.getY();
    float d = sqrt( pow(x, 2) + pow(y, 2));
    DEB_MSG(cout << "calculated distance: " << d << " \n");
    actionlog(120) << "calculated distance: " << d << ende;
    VecPosition ball_pos = p->ball_pos;
    if (my_side == TS_Right) {
      ball_loc = -ball_loc;
      ball_pos = -ball_pos;
    }
    float ang  = fabs((ball_pos - VecPosition(-ServerParam::instance()->getSPPitchLength()/2,0)).getDirection());
    switch (p->mode) {
    case SPM_Their_Kick_Off:
      DEB_MSG(cout << "adding info from kickoff\n");
      actionlog(110) << "adding info from kickoff" << ende;
      if ((KOpreviousExits[0].getDistanceTo(ball_loc) < CoachParam::instance()->getDspDefSamePosBuffer()) ||
	  (KOpreviousExits[1].getDistanceTo(ball_loc) < CoachParam::instance()->getDspDefSamePosBuffer()) ||
	  (KOpreviousExits[2].getDistanceTo(ball_loc) < CoachParam::instance()->getDspDefSamePosBuffer()) ||
	  (KOpreviousExits[3].getDistanceTo(ball_loc) < CoachParam::instance()->getDspDefSamePosBuffer())) {
      DEB_MSG(cout << "already stored that kick off value\n");
      added = true;
      }
      else if ((d <= 12) && (d >= 10) && (ball_loc.getX() < 0)) {
	if (ball_pos.getY() >= 0) {
	  KOpreviousExits[1] = KOpreviousExits[0];
	  KOpreviousExits[0] = ball_loc;
	}
	else if (ball_pos.getY() < 0) {
	  KOpreviousExits[3] = KOpreviousExits[2];
	  KOpreviousExits[2] = ball_loc;
	}
	added = true;
      }
      else if ((ball_loc.getX() >= -2 ) && (ball_loc.getX() <=0) && 
	       (fabs(ball_loc.getY()) >= 10)) {
	if (ball_pos.getY() >= 0) {
	  KOpreviousExits[1] = KOpreviousExits[0];
	  KOpreviousExits[0] = ball_loc;
	}
	else if (ball_pos.getY() < 0) {
	  KOpreviousExits[3] = KOpreviousExits[2];
	  KOpreviousExits[2] = ball_loc;
	}
	added = true;
      }
      DEB_MSG(cout << "stored kickoff positions:\n");
      for (int q = 0; q < 4; ++q) 
	DEB_MSG(cout << KOpreviousExits[q] << "\n");
      break;
    case SPM_Their_Kick_In:
      DEB_MSG(cout << "adding info from kickin\n");
      actionlog(110) << "adding info from kickin" << ende;
      if ((d <= 12) && (d >= 8) && 
	  ( ball_loc.getX() < ServerParam::instance()->getSPPitchLength()/2) && 
	  ( ball_loc.getX() > -ServerParam::instance()->getSPPitchLength()/2) &&
	  ( ball_loc.getY() < ServerParam::instance()->getSPPitchWidth()/2) && 
	  ( ball_loc.getY() > -ServerParam::instance()->getSPPitchWidth()/2) &&
	  (VecPosition(-10,0).getDistanceTo(((ball_loc-ball_pos).rotate(-ang))+ball_pos) > CoachParam::instance()->getDspDefSamePosBuffer())) {
	DEB_MSG(cout << "angle: " << ang << "\n");
	addLoc(KIpreviousExits, ((ball_loc-ball_pos).rotate(-ang))+ball_pos, ball_pos, &KIcurrentSize);
	added = true;
      }
      break;
    case SPM_Their_Corner_Kick:
      DEB_MSG(cout << "adding info from corner kick\n");
      actionlog(110) << "adding info from corner kick" << ende;
      if ((ball_loc.getX() >= -ServerParam::instance()->getSPPitchLength()/2) && 
	  (ball_loc.getX() <= -ServerParam::instance()->getSPPitchLength()/2 + 18) && 
	  (fabs(ball_loc.getY()) < 22.0) &&
	  (fabs(ball_loc.getY()) > 18.0)) {
	addLoc(CKpreviousExits, ball_loc + ball_pos, ball_pos, &CKcurrentSize);
	added = true;
      }
      else if ((d <= 12) && (d >= 8) && 
	       ( ball_loc.getX() < ServerParam::instance()->getSPPitchLength()/2) && 
	       ( ball_loc.getX() > -ServerParam::instance()->getSPPitchLength()/2) &&
	       ( ball_loc.getY() < ServerParam::instance()->getSPPitchWidth()/2) && 
	       ( ball_loc.getY() > -ServerParam::instance()->getSPPitchWidth()/2)) {
	addLoc(CKpreviousExits, ball_loc + ball_pos, ball_pos, &CKcurrentSize);
	added = true;
      }
      else if ((ball_loc.getX() == ball_loc.getY() -2) &&
	       (fabs(ball_loc.getY()) >= 20) &&
	       (fabs(ball_loc.getY()) <= 25)) {
	addLoc(CKpreviousExits, ball_loc + ball_pos, ball_pos, &CKcurrentSize);
	added = true;
      }
      break;
    case SPM_Their_Goal_Kick:
      DEB_MSG(cout << "adding info from goal kick\n");
      actionlog(110) << "adding info from goal kick" << ende;
      if ((ball_loc.getX() <= ServerParam::instance()->getSPPitchLength()/2) && 
	  (ball_loc.getX() >= ServerParam::instance()->getSPPitchLength()/2 - 18) && 
	  (fabs(ball_loc.getY()) < 22.0) &&
	  (fabs(ball_loc.getY()) > 18.0)) {
	addLoc(GKpreviousExits, ball_loc + ball_pos, ball_pos, &GKcurrentSize);
	added = true;
      }
      else if ((ball_loc.getX() <= ServerParam::instance()->getSPPitchLength()/2 - 16) &&
	       (ball_loc.getX() >= ServerParam::instance()->getSPPitchLength()/2 - 20) &&
	       (fabs(ball_loc.getY()) <= 20.0)) {
	addLoc(GKpreviousExits, ball_loc + ball_pos, ball_pos, &GKcurrentSize);
	added = true;
      }
      break;
    case SPM_Their_Free_Kick:
      DEB_MSG(cout << "adding info from free kick\n");
      actionlog(110) << "adding info from free kick" << ende;
      if ((d <= 12) && (d >= 8) && 
	  ( ball_loc.getX() < ServerParam::instance()->getSPPitchLength()/2) && 
	  ( ball_loc.getX() > -ServerParam::instance()->getSPPitchLength()/2) &&
	  ( ball_loc.getY() < ServerParam::instance()->getSPPitchWidth()/2) && 
	  ( ball_loc.getY() > -ServerParam::instance()->getSPPitchWidth()/2) &&
	  (VecPosition(-10,0).getDistanceTo(((ball_loc-ball_pos).rotate(-ang))+ball_pos) > CoachParam::instance()->getDspDefSamePosBuffer())) {
	DEB_MSG(cout << "angle: " << ang << "\n");
	addLoc(FKpreviousExits, ((ball_loc-ball_pos).rotate(-ang))+ball_pos, ball_pos, &FKcurrentSize);
     	added = true;
      }
      break;
    case SPM_Their_Goalie_Catch:
      DEB_MSG(cout << "adding info from goalie catch\n");
      actionlog(110) << "adding info from goalie catch" << ende;
      if ((GCpreviousExits[0].getDistanceTo(ball_loc) < CoachParam::instance()->getDspDefSamePosBuffer()) ||
	  (GCpreviousExits[1].getDistanceTo(ball_loc) < CoachParam::instance()->getDspDefSamePosBuffer()) ||
	  (GCpreviousExits[2].getDistanceTo(ball_loc) < CoachParam::instance()->getDspDefSamePosBuffer()) ||
	  (GCpreviousExits[3].getDistanceTo(ball_loc) < CoachParam::instance()->getDspDefSamePosBuffer())) {
      DEB_MSG(cout << "already stored that kick off value\n");
      added = true;
      }
      else if ((ball_loc.getX() <= ServerParam::instance()->getSPPitchLength()/2) && 
	       (ball_loc.getX() >= ServerParam::instance()->getSPPitchLength()/2 - 18) && 
	       (fabs(ball_loc.getY()) < 22.0) &&
	       (fabs(ball_loc.getY()) > 18.0)) {
	if (ball_pos.getY() >= 0) {
	  GCpreviousExits[1] = GCpreviousExits[0];
	  GCpreviousExits[0] = ball_loc;
	}
	else if (ball_pos.getY() < 0) {
	  GCpreviousExits[3] = GCpreviousExits[2];
	  GCpreviousExits[2] = ball_loc;
	}
	added = true;
      }
      else if ((ball_loc.getX() <= ServerParam::instance()->getSPPitchLength()/2 - 16) &&
	       (ball_loc.getX() >= ServerParam::instance()->getSPPitchLength()/2 - 20) &&
	       (fabs(ball_loc.getY()) <= 20.0)) {
	if (ball_pos.getY() >= 0) {
	  GCpreviousExits[1] = GCpreviousExits[0];
	  GCpreviousExits[0] = ball_loc;
	}
	else if (ball_pos.getY() < 0) {
	  GCpreviousExits[3] = GCpreviousExits[2];
	  GCpreviousExits[2] = ball_loc;
	}
	added = true;
      }
      DEB_MSG(cout << "stored goalie catch positions:\n");
      for (int q = 0; q < 4; ++q) 
	DEB_MSG(cout << GCpreviousExits[q] << "\n");
      break;
    default:
      DEB_MSG(cout << "this is not a defensive problem \n");
      actionlog(110) << "this is not a defensive problem" << ende;
      break;
    }

  }
  
  DEB_MSG(cout << "done adding info\n");
  actionlog(120) << "done adding info" << ende;
  return added;
}

void DefOppModel::addLoc(VecPosition* previousExits, VecPosition ball_loc,
			 VecPosition ball_pos, int* currentSize) {
  VecPosition tmp = ball_loc - ball_pos;
  if (ball_pos.getY() < 0) tmp.setY(-tmp.getY());
  for (int h = 0; h < *currentSize; ++h) {
    //DEB_MSG(cout << previousExits[h] << ball_loc << p->ball_pos << "\n");
    //DEB_MSG(cout << tmp << "\n");
    //DEB_MSG(cout << "distance: " << previousExits[h].getDistanceTo(tmp) << "\n");
    if (previousExits[h].getDistanceTo(tmp) < CoachParam::instance()->getDspDefSamePosBuffer()) {
      DEB_MSG(cout << "already stored that value\n");
      return;
    }
  }
  DEB_MSG(cout << "didn't really return\n");
  DEB_MSG(cout << "callling addLoc to actually store position: " << Mem->GetTime() << "\n"); 
  DEB_MSG(cout << "ball started at: " << ball_pos << "\n");
  DEB_MSG(cout << "ball is at: " << ball_loc << "\n");
  DEB_MSG(cout << "relative location: " << ball_loc - ball_pos << "\n");
  if (*currentSize >= CoachParam::instance()->getSppOmNumExits()) {
    DEB_MSG(cout << "thinks the storage array is full\n");
    actionlog(120) << "thinks the storage array is full" << ende;
    int i = 0;
    for (i = 0; i < CoachParam::instance()->getSppOmNumExits() - 1; ++i) {
      previousExits[i] = previousExits[i+1];
    }
    if (ball_pos.getY() >=0) {
      previousExits[*currentSize].setX(ball_loc.getX() - ball_pos.getX());
      previousExits[*currentSize].setY(ball_loc.getY() - ball_pos.getY());
    }
    else if (ball_pos.getY() < 0) {
      previousExits[*currentSize].setX(ball_loc.getX() - ball_pos.getX());
      previousExits[*currentSize].setY(-(ball_loc.getY() - ball_pos.getY()));
    }
  }
  else {
    DEB_MSG(cout << "thinks there is still space in the storage array\n");
    actionlog(120) << "thinks there is still space in the storage array" << ende;
    if (ball_pos.getY() >=0) {
      previousExits[*currentSize].setX(ball_loc.getX() - ball_pos.getX());
      previousExits[*currentSize].setY(ball_loc.getY() - ball_pos.getY());
    }
    else if (ball_pos.getY() < 0) {
      previousExits[*currentSize].setX( ball_loc.getX() - ball_pos.getX() );
      previousExits[*currentSize].setY( -(ball_loc.getY() - ball_pos.getY()));
    }
    ++(*currentSize);
  }
  int j = 0;
  DEB_MSG(cout << *currentSize << " values stored thus far\n");
  actionlog(130) << *currentSize << " values stored thus far"  << ende;
  for (j = 0; j < *currentSize; ++j) {
    DEB_MSG(cout << j+1 << ": " << previousExits[j] << "\n");
  }
}











