/* -*- Mode: C++ -*- */

/* This is the base class upon which the Monotoring, Diagnosis, Planner, and
   Execution will inherit */

#ifndef _CONTROLLER_FUNCTION_H_
#define _CONTROLLER_FUNCTION_H_

#include <pthread.h>
#include <string.h>

const int MAX_TYPE_LENGTH = 30;

class ControllerFunction {
public:
  ControllerFunction(char* type);  
  virtual ~ControllerFunction();  
  
  const char* getType(void) const {return type;}

  /* this is stuff to start an asynchrounous run. It's the sub class's job
     to handle getting information to and from the thread
     mutex_data_ready and cv_data_ready are set up for the thread to use
     to wait for something to do. However, the subclass should handle 
     mutual exclusion to the data itself */
  /* the created thread should run until the process dies and use the data_ready
     stuff to get more data when needed */
  /* returns an error code if the the thread calls fail */
  int StartAsynchRun();
  //this is the function which will be called asynchronously
  virtual void* asynch_worker() = 0;

  void end_thread();

protected:
  char type[MAX_TYPE_LENGTH];

  bool asynch_started;
  
  pthread_t thrd;  
  pthread_mutex_t mutex_data_ready;
  pthread_cond_t cv_data_ready;
  bool data_ready;  
  
};

#endif // _CONTROLLER_FUNCTION_H_
