#include <stdio.h>
#include "ControllerFunction.h"

/* This is the base class upon which the Monotoring, Diagnosis, Planner, and
   Execution will inherit */

ControllerFunction::ControllerFunction(char* type) 
{
  int errcode;
  
  strcpy(this->type, type);

  asynch_started = false;
  
  data_ready = false;  

  if ((errcode=pthread_mutex_init(&mutex_data_ready, NULL))) {
      fprintf(stderr, "mutex_init: %s\n", strerror(errcode)); 
      return;
  }
  if ((errcode=pthread_cond_init (&cv_data_ready, NULL))) {
      fprintf(stderr, "cond_init: %s\n", strerror(errcode)); 
      return;
  }
}

ControllerFunction::~ControllerFunction()
{
  if (asynch_started)
    pthread_cancel(thrd);  
}

void ControllerFunction::end_thread()
{
  //SMURF: should we check for errors?
  if (!asynch_started)
    return;
  pthread_cancel(thrd);  
  void* ret;
  pthread_join(thrd, &ret);
}



//this function is where the thread actually starts
void * run_proxy(void * mythis)
{
  return  ((ControllerFunction*)mythis)->asynch_worker();
}

int ControllerFunction::StartAsynchRun()
{
  asynch_started = true;
  //pfr: 10/23/01: the coach is the only agent who runs threads
  return pthread_create(&thrd, NULL, run_proxy, (void*)this);
}


/* Here's how you want to use the condition variable to get more data
   to the runnning thread */
/* this is what the worker thread might look like
{
  while(1) {
    pthread_mutex_lock(&mutex_data_ready);
    while (!data_ready) {
      pthread_cond_wait(&cv_data_ready, &mutex_data_ready);
    }
    pthread_mutex_unlock(&mutex_data_ready);
    
    //acquire data mutex
    //copy data
    //release data mutex

    //indicate that more data could be put in now
    pthread_mutex_lock(&mutex_data_ready);
    data_ready = false;    
    pthread_mutex_unlock(&mutex_data_ready);

    //do your work. maybe allowing interuptions somehow
  }
}
*/

/* this is how you give more data to the worker thread
{
  //acquire data mutex
  // might want to notice whether data_ready is true or not- if it is, it probably 
  // means that the worked thread didn't have time to copy out the data
  //put data in vars
  //release data mutex

  pthread_mutex_lock(&mutex_data_ready);
  data_ready = true;    
  pthread_cond_signal(&cv_data_ready);
  pthread_mutex_unlock(&mutex_data_ready);
}
*/
