#include <stdlib.h>
#include <iostream.h>
#include "CoachParam.h"
#include "BallMovement.h"
#include "Logger.h"
using namespace spades;

BallMovement::BallMovement(void) {
  times = new int[CoachParam::instance()->getSppOmObsInterval()];
  locations = new VecPosition[CoachParam::instance()->getSppOmObsInterval()];
  currentStep = 0;
  
}

#ifdef NEVER
BallMovement::BallMovement(int* time, VecPosition* locs, int size) {
  if (size > CoachParam::instance()->getSppOmObsInterval()) 
    errorlog << "attempt to put too many times and locations in ball movement" << ende;
  else {
    times = time;
    locations = locs;
    currentStep = size - 1;
  }
  
//    int i = 0;
//    for (i = 0; i < size; ++i) {
//      if (i >= size) 
//        errorlog << "attempt to put too many times and locations in ball movement\n" << ende;
//      else {
//        times + i = time + i;
//        locations + i = locs + i;
//      }
//    }
}
#endif

BallMovement::~BallMovement(void) {
  delete []times;
  delete []locations;
}

VecPosition BallMovement::getFinalPosition(void) {
  return locations[currentStep-1];
}

int BallMovement::getTotalTime(void) {
  int time = 0;
  for (int i = 0; i < currentStep; ++i) {
    time = time + times[i];
  }
  return time;
}

VecPosition BallMovement::getBallPosition(int idx)
{
  if (idx < 0 || idx >= currentStep) {
    errorlog << "getBallPosition: idx out of range " << idx << ende;
    return 0;
  }
  return locations[idx];
}
 
VecPosition BallMovement::getPositionTime(int idx)
{
  if (idx < 0 || idx >= currentStep) {
    errorlog << "getPositionTime: idx out of range " << idx << ende;
    return 0;
  }
  return times[idx];
}

VecPosition BallMovement::getPositionTotalTime(int idx)
{
  if (idx < 0 || idx >= currentStep) {
    errorlog << "getPositionTotalTime: idx out of range " << idx << ende;
    return 0;
  }

  int time = 0;
  for (int i = 0; i <= idx; ++i) {
    time = time + times[i];
  }
  return time;
}

void BallMovement::addBallPosition(VecPosition position, int time) {
  if (currentStep < CoachParam::instance()->getSppOmObsInterval()) {
    times[currentStep] = time;
    locations[currentStep] = position;
    ++currentStep;
  } else {
    errorlog << "Tried to add too many ball positions: " << currentStep
	     << ", STEP:  " << CoachParam::instance()->getSppOmObsInterval() << ende;
  }
}

void BallMovement::removeBallPosition(int idx)
{
  for (int i=idx; i+1 < currentStep; i++) {
    locations[i] = locations[i+1];
    times[i] = times[i+1];
  }
  currentStep--;
}


void BallMovement::copyFrom(BallMovement* bm) {
  //cout << "copying bm: " << bm->currentStep<< " steps \n";
  for (int i = 0; i < bm->currentStep; ++i) {
    times[i] = bm->times[i];
    locations[i] = bm->locations[i];
  }
  currentStep = bm->currentStep;
} 

