#!/usr/local/bin/perl5 -w

# This script turns a names file into a piece of C++ code
# Everything is in my own made up format, so this probably isn't very portable

# The format of the names file is
# # is a comment line
# All lines between STARTHEADER and ENDHEADER are copied verbatim to the output
# First non comment line: function return type
# second non-comment line: function name
# every other line
# <name> <class name with constructor args>

$usage = "$0 <names file> <output code file>";

$names_fn = shift @ARGV;
$code_fn = shift @ARGV;

(defined($names_fn) && defined($code_fn)) || die $usage;

open(NAMES, "<$names_fn") || die "Could not open name file '$names_fn': $!";
open(CODE,  ">$code_fn") || die "Could not open code file '$code_fn': $!";

print CODE <<EOH;
/* -*- Mode: C++ -*- */
/* DO NOT EDIT
   These file was automatically generated from $names_fn by $0 */

#include <string.h>
#include <algorithm>
#include "Logger.h"

/* Begin names file header code */
EOH

# mode constants
$MODE_FIND_START_HEADER = 0;
$MODE_COPY_HEADER = 1;
$MODE_FIND_RETURN_TYPE = 2;
$MODE_FIND_FUNCTION_NAME = 3;
$MODE_REGULAR_LINE_PROCESSING = 4;

$mode = $MODE_FIND_START_HEADER;

$line_no = 0;
while (<NAMES>)
  {
    $line_no++;

    chomp;

    # This is up here to remove # comment deletion
    if ($mode == $MODE_COPY_HEADER)
      {
	if ($_ eq 'ENDHEADER')
	  {
	    print CODE <<EOS;
/* End names file header code */

EOS
	    $mode = $MODE_FIND_RETURN_TYPE;
	    next;
	  }
	print CODE <<EOS;
#line $line_no "$names_fn"
$_
EOS
	print CODE "\n";
	next;
      }

    s/\#.*//;
    next if (/^\s*$/);

    if ($mode == $MODE_FIND_START_HEADER)
      {
	($_ eq 'STARTHEADER') || die "I was expecting STARTHEADER";
	$mode = $MODE_COPY_HEADER;
      }
    elsif ($mode == $MODE_FIND_RETURN_TYPE)
      {
	$rettype = $_;
	print CODE <<EOS;
$rettype*	
EOS
        $mode = $MODE_FIND_FUNCTION_NAME;
      }
    elsif ($mode == $MODE_FIND_FUNCTION_NAME)
      {
	$funcname = $_;
	print CODE <<EOS;
$funcname (std::string name)
{
  static bool initialized = false;
  if (!initialized)
    {
      initializeStatics();
      initialized = true;
    }
  std::transform(name.begin(), name.end(), name.begin(), ::tolower);
  if (0)
    ;
EOS
        $mode = $MODE_REGULAR_LINE_PROCESSING;
      }
    elsif ($mode == $MODE_REGULAR_LINE_PROCESSING)
      {
	/\s*(\w*)\s+(.*)/ || die "Did not understand line $line_no: $_";
	$name = $1;
	$code = $2;
	$name = lc($name);
	print CODE <<EOS;
#line $line_no "$names_fn"
  else if (name == "$name")
#line $line_no "$names_fn"
    return new $code;
EOS
      }
    else
      {
	die "What is mode? $mode";
      }
  }

print CODE <<EOS;
  errorlog << "Did not recognize atom '" << name << "'" << spades::ende;
  return NULL;
}
EOS
