/* -*- Mode: c++ -*- */

/* Random useful stuff */

#ifndef _MISC_H_
#define _MISC_H_

#include <iostream>
#include <string>
#include <math.h>

enum FuzzyBool {
  FB_False,
  FB_True,
  FB_Unknown,
  FB_Maybe,
  FM_NoValue
};


inline double Max(double a, double b) 
{ if (a > b) return a; return b; }
inline int Max(int a, int b) 
{ if (a > b) return a; return b; }
inline unsigned Max(unsigned a, unsigned b) 
{ if (a > b) return a; return b; }

inline double Min(double a, double b) 
{ if (a < b) return a; return b; }
inline int Min(int a, int b) 
{ if (a < b) return a; return b; }
inline unsigned Min(unsigned a, unsigned b) 
{ if (a < b) return a; return b; }

#define MinMax(min, x, max) (Max((min), Min((x), (max))))
			     
#define signf(x) ( ((x) >= 0.0) ? 1.0 : -1.0) 

inline int Sqr(int x){ return x*x; }
inline float Sqr(float x) { return x*x; }
inline double Sqr(double x) { return x*x; }
inline float Exp(float x, int y) { float a = 1; for (int i=0; i<y; i++) a*=x; return a; }

//From Dave M.
#define sigmoid(x) (1/(1+exp(-x)))
#define sigmoid_deriv(x) (1/((1+exp(-x))*(1+exp(x))))
#define soft_not(x) (1-(x))
#define soft_and(x, y) ((x)*(y))
#define soft_or(x,y) (1-(1-(x))*(1-(y)))
#define soft_greater(x,y,delta) (sigmoid(((x)-(y))/(delta)))
#define soft_less(x,y,delta) (sigmoid(((y)-(x))/(delta)))
inline float soft_equal(float x, float y, float delta){
  float z = (x-y)/delta;
  return exp(-z*z);
}

inline float soft_if(float p, float x, float y){
  return p*x + (1-p)*y;
}

int QuadraticFormula(float a, float b, float c, float* psol1, float* psol2);

// given a numbers that was read from text (with digits of precision),
// return the half error bound 
double getErrorFor(double d, int digits);

double round(double x, int p=0);
inline int roundToInt(double x) 
{
  return (int)rint(x);
} 

inline double weightedSum (double v1, double w1, double v2)
{
  return (w1*v1 + (1.0-w1)*v2);
}
inline double weightedSum (double v1, double w1, double v2, double w2)
{
  return (w1*v1 + w2*v2) / (w1+w2);
}

inline double gaussian_func(double x, double mean = 0.0, double stdev = 1.0)
{
  static const double piterm = 1.0 / sqrt(2 * M_PI);

  return (1.0 / stdev) * piterm * pow(M_E, - Sqr(x-mean) / (2*Sqr(stdev)));
}
double gaussian_sample(double mean = 0.0, double stdev = 1.0);
double gaussian_sample_twosided(double mean, double stdev_minus, double stdev_plus);

/* p is the probability that we stop at a particular number
   high p => lower expected value */
int discrete_exponential_sample(double p);

inline double range_random(double lo, double hi)
{ return drand48() * (hi-lo) + lo; }
//returns an int in the range [0, max)
inline int int_random(int max)
{ return rand() % max; }
inline double prob_random()
{ return range_random(0.0, 1.0); } 
   
extern const char char_for_num_array[16];
inline char char_for_num(int num)
{ return char_for_num_array[num]; }
int num_for_char(char c);


template<class T>
class DerefPrinter
{
public:
  DerefPrinter(std::ostream& o, const std::string& sep) : o(o), sep(sep) {}
  void operator() (T* t) { o << *t << sep; }
private:
  std::ostream& o;
  std::string sep;
};


#endif
