/* Random useful stuff */

#include <math.h>
#include "misc.h"
#include "Geometry.h"
#include "Logger.h"

using namespace spades;

int
QuadraticFormula(float a, float b, float c, float* psol1, float* psol2)
{
  float d = Sqr(b) - 4*a*c;
  if (fabs(d) < EPSILON) {
    *psol1 = -b / (2 * a);
    return 1;
  } else if (d < 0) {
    return 0;
  } else {
    d = sqrt(d);
    *psol1 = (-b + d ) / (2 * a);
    *psol2 = (-b - d ) / (2 * a);
    return 2;
  }
}

double
getErrorFor(double d, int digits)
{
  if (d == 0)
    return pow(10, -digits) * 0.5;
  d = fabs(d);
  return pow(10, floor(log10(d)) - digits + 1) * 0.5;

}


double
round(double x, int p)
{
  double s = signf(x);
  x = fabs(x);
  double m = pow(10.0, p);
  //printf("m: %f\n", m);
  double f = fmod(x,m);
  //printf("f: %f\n", f);
  //printf("pow: %f\n", .5*m);
  if (f >= .5*m) {
    //printf("Going up");
    x += (m-f);
  } else {
    //printf("Going down");
    x -= f;
  }
  return s*x;
} 


/* This code is from numerical recipes in C (slightly modified)
   and taken from CMU CS zephyr archives
   http://zarchive.srv.cs.cmu.edu/prog/zquery?zid=152861
*/
  /* generates a normal deviate of std dev 1, mean 0 */
  /* from num recipes in C */
  /* uses the unix improved random number generator as its base */
  /* modified to restrict to a subrange l,u uses rejection sampling */
  /* and a bit of code to generate efficiently in the tails- narrow */
  /* regions are the only potential problem */
typedef double realtype;
static int iset=0;
static realtype gset,lastl,lastu;

realtype gasdev(realtype l,realtype u)
{
  realtype fac,r,v1,v2,m,a,result;
  do {
    if  ((iset == 0)||((l!=lastl)||(u!=lastu))) {
      /* code to generate out in the tails of the normal*/
      lastl = l;
      lastu = u;
      if((u<0)||(l>0))
        {
          m = Max(l,-u);
          a = (realtype)exp((double)(-0.5*Sqr(m)));
        }
      else
        a = 1.0;
      do {
        v1=range_random(-a,a);
        v2=range_random(-a,a);
        r=v1*v1+v2*v2;
      } while (r >= a);
      fac=sqrt(-2.0*log(r)/r);
      gset=v1*fac;
      iset=1;
      result = v2*fac;
    } else {
      iset=0;
      result = gset;
    }
    /* flip signs if we are generating a tail */
    if(((u<0)&&(result>0))||((l>0)&&(result<0)))
      result = -result;
  } while((result<l)||(result>u));
  return result;
}
double gaussian_sample(double mean, double stdev)
{
  return gasdev(-1000, 1000)*stdev + mean;
}
double gaussian_sample_twosided(double mean, double stdev_minus, double stdev_plus)
{
  double samp = gasdev(-1000, 1000);
  if (samp < 0)
    return mean + samp*stdev_minus;
  else
    return mean + samp*stdev_plus;
}

int discrete_exponential_sample(double p)
{
  for (int count = 0; ; count++) {
    if (range_random(0,1) <= p)
      return count;
  }

  errorlog << "discrete_exponential_sample: I should never get here" << ende;
  return -1;
}

const char char_for_num_array[16] =
{'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

int num_for_char(char c)
{
  for (int i = 0; i<16; i++)
    if (char_for_num_array[i] == c)
      return i;
  return -1;
}

