#!/usr/local/bin/perl5 -w

# This script permutes a formation. It expacts the replacement file to look like this:
# %G: <num>
# %D1: <num>
# %D2: <num>
# %D3: <num>
# %DM1: <num>
# %DM2: <num>
# %M1: <num>
# %MF1: <num>
# %MF2: <num>
# %F1: <num>
# %F2: <num>
# representing the goalie, 3 defenders, 2 def or mid, 1 midfield, 2 mid or for, 2 for
# THe initiali formation is assumed to be G=1, D=2-5, M=6-8, F=9-11

$usage = "$0 <repl input file> <input file> <output file>";

$cmdline = join ' ', @ARGV;

$replfn = shift @ARGV;
$infn = shift @ARGV;
$outfn = shift @ARGV;
die $usage if (!defined($infn) or !defined($outfn));

# maps the new formation numbers to the old ones
@perm = (0) x 12;

$rolestr{'%G'} = 1;
$rolestr{'%D1'} = 2;
$rolestr{'%D2'} = 3;
$rolestr{'%D3'} = 4;
$rolestr{'%DM1'} = 5;
$rolestr{'%DM2'} = 6;
$rolestr{'%M1'} = 7;
$rolestr{'%MF1'} = 8;
$rolestr{'%MF2'} = 9;
$rolestr{'%F1'} = 10;
$rolestr{'%F2'} = 11;

#First, read the replacements to do
open(REPL, "<$replfn") || die "Could not open replacements file '$replfn': $!";
while (<REPL>)
  {
    chomp;
    s/\#.*//;
    next if (/^\s*$/);
    ($role, $num) = split '\s*:\s*';
    exists $rolestr{$role} || die "'$role' not found";
    #$perm[$rolestr{$role}] = $num
    $perm[$num] = $rolestr{$role};
  }
close (REPL);

# Now, process the input file to the output file
open(INFH, "<$infn") || die "Could not open in file '$infn': $!";
open(OUTFH, ">$outfn") || die "Could not open out file '$outfn': $!";

print OUTFH <<EOH;
# DO NOT EDIT
# THis is an automatically generated file create by $0 with this command line
# $cmdline
EOH

$idx = 1;
while (<INFH>)
  {
    if (/^\s*Name:/)
      {
	s/$/_perm/;
	print OUTFH;
      }
    elsif (/^\s*\#/ || /^\s*$/)
      {
	print OUTFH;
      }
    else
      {
	#warn "Region $idx: $_";
	$regions[$idx] = $_;
	$idx++;
      }
  }
close (INFH);

for ($idx = 1; $idx <= 11; $idx++)
  {
    print OUTFH $regions[$perm[$idx]];
  }

close (OUTFH);


