/* -*- Mode: C++ -*- */

/* This class provides a WorldModelInterface liek clanglib wants
   based upon a WorldState */

#ifndef WORLD_STATE_WMI_H
#define WORLD_STATE_WMI_H

#include "WorldModelInterface.h"
#include "WorldState.h"
#include "Logger.h"

// This is the interface that regions need
class WorldStateRWMI
  : public RegionWorldModelInterface
{
public:
  WorldStateRWMI(const WorldState& ws, TeamSide my_side);

  /*
   * Returns a vector holding the global position of the agent specified by num
   * The argument ourside is true if the player number specifies a player on our team
   * (and false if it is the opponent's team)
   */
  VecPosition
  getGlobalPosition(rcss::clang::UNum::unum_t num, bool ourside);

  /*
   * Returns a vector containing the current ball position. 
   *
   */
  rcss::geom::Vector2D
  getBallPos();

  bool
  useRightSideCoordinates() { return my_side == TS_Right; }

private:
  const WorldState& ws;
  TeamSide my_side;
};


#endif

