
#include "WorldStateWMI.h"
#include "Logger.h"

using namespace spades;


WorldStateRWMI::WorldStateRWMI(const WorldState& ws, TeamSide my_side)
  : ws(ws), my_side(my_side)
{
  if (my_side != TS_Left && my_side != TS_Right)
    {
      errorlog << "WorldStateRWMI: side must be left or right!" << ende;
      my_side = TS_Left;
    }
}

/*
 * Returns a vector holding the global position of the agent specified by num
 * The argument ourside is true if the player number specifies a player on our team
 * (and false if it is the opponent's team)
 */
VecPosition
WorldStateRWMI::getGlobalPosition(rcss::clang::UNum::unum_t num, 
				  bool ourside)
{
  const PlayerInfo* pinfo = ws.getPlayer(ourside ? my_side : invertSide(my_side),
					 (Unum)num);
  if (!pinfo)
    {
      errorlog << "WorldStateRWMI: asked about non-existent player "
	       << my_side << " " << ourside << " " << num << spades::ende;
      return VecPosition(-1000, -1000);
    }
  else
    {
      VecPosition pos = pinfo->getPos();
      if (useRightSideCoordinates())
	pos = pos.flipCoords();
      return pos;
    }
}

/*
 * Returns a vector containing the current ball position. 
 *
 */
rcss::geom::Vector2D
WorldStateRWMI::getBallPos()
{
  VecPosition pos = ws.getBall().getPos();
  if (useRightSideCoordinates())
    pos = pos.flipCoords();
  return pos.convertToVector2D();
}
