/* -*- Mode: C++ -*- */

/* This class keeps a history of some number of world states */

#ifndef _WORLD_HISTORY_H_
#define _WORLD_HISTORY_H_

#include <list>
#include "WorldState.h"
#include "misc.h"

/* The idea: We keep a list of past world state, dropping the oldest ones
   We also have a pending world state which can be updated.
   Then when the information is done, call finishPending
   That moves it into the normal list and makes a new pending state based on the
   previous one */
   
class WorldHistory 
{
public:
  WorldHistory(int cycles_to_store);
  ~WorldHistory() {}

  // ensures that we are storing at least this many cycles
  int ensureStoring(int cycles)
  { return cycles_to_store = Max(cycles, cycles_to_store); }

  int getNumAvail() const { return history.size(); }
  const WorldState& getWorldState(int cycles_back = 0) const;

  WorldState& getPendingWorldState() { return pending_world_state; }

  void finishPending();

  // This is kind of a hack, but I can't figure a real nice way to do this
  int getLastGoalieCatchTime() const { return last_goalie_catch_time; }
  //reads the time from the current world state
  void setLastGoalieCatchTime();

  int getLastPlayModeChangeTime() const { return last_play_mode_change_time; }
  
private:
  typedef std::list<WorldState> HistoryStorage;

  int cycles_to_store;
  //we'll store the most recent cycles at the front of the list
  HistoryStorage history;
  WorldState pending_world_state;

  int last_goalie_catch_time;
  int last_play_mode_change_time;
};



#endif
