/* This class keeps a history of some number of world states */

#include "WorldHistory.h"
#include "Logger.h"

using namespace spades;

WorldHistory::WorldHistory(int cycles_to_store)
  : cycles_to_store(cycles_to_store),
    last_goalie_catch_time(-1),
    last_play_mode_change_time(-1)
{
  pending_world_state.setDefaultBeginGame();
}


const WorldState&
WorldHistory::getWorldState(int cycles_back) const
{
  if (cycles_back < 0 || cycles_back >= (signed)history.size())
    {
      errorlog << "getWorldState: out of range: " << cycles_back << ", num stored=" << history.size() << ende;
      return history.back();
    }

  HistoryStorage::const_iterator iter = history.begin();
  advance(iter, cycles_back);
  return *iter;
}


void
WorldHistory::finishPending()
{
  if (!history.empty() &&
      history.front().getPlayMode() != pending_world_state.getPlayMode())
    {
      actionlog(150) << "Got a change in play mode, recording that time" << ende;
      last_play_mode_change_time = pending_world_state.getTime();
    }
  history.push_front(pending_world_state);
  if ((signed)history.size() > cycles_to_store)
    history.pop_back();
  pending_world_state = history.front();
  pending_world_state.clearTransientValues();
}


void
WorldHistory::setLastGoalieCatchTime()
{
  last_goalie_catch_time = getWorldState().getTime();
}

