/* -*- Mode: C++ -*- */

#ifndef _TRAINERCONNECTION_H_
#define _TRAINERCONNECTION_H_

#include <fstream>
#include <pthread.h>
#include <rcssbase/net/udpsocket.hpp>
#include <rcssbase/net/socketstreambuf.hpp>
#include "LoggingSocketStreamBuf.h"
#include "Geometry.h"

class TrainerConnection
{
public:
  TrainerConnection();
  ~TrainerConnection();

  bool initializeConnection();

  //SMURF: this is not the right way to do this
  // I should make a command class like CoachCommand has
  bool sendToServer(const char* s);
  bool moveBall(const VecPosition& v);

  void printReadStreamTo(std::ostream& os);
  
protected:
  rcss::net::Addr server_addr;
  rcss::net::UDPSocket socket;
  std::ofstream send_log;
  std::ofstream recv_log;
  LoggingSocketStreamBuf write_strmbuf;
  LoggingSocketStreamBuf read_strmbuf;

  std::ostream write_strm;
  std::istream read_strm;

  pthread_t thrd;
  
  static void* readStream(void* arg);
};


#endif
