/* -*- Mode: C++ -*- */

#include <sstream>
#include "TrainerConnection.h"
#include "CoachParam.h"
#include "Logger.h"

using namespace spades;
using namespace std;


TrainerConnection::TrainerConnection()
  : server_addr( CoachParam::instance()->getOnlineTrainerPort(), CoachParam::instance()->getOnlineHost() ),
    socket(),
    send_log((CoachParam::instance()->getLogfileDir() + '/' + CoachParam::instance()->getTrainerSendLogFN()).c_str()),
    recv_log((CoachParam::instance()->getLogfileDir() + '/' + CoachParam::instance()->getTrainerRecvLogFN()).c_str()),
    write_strmbuf( send_log, socket, server_addr ),
    read_strmbuf( recv_log, socket, server_addr ),
    write_strm( &write_strmbuf ),
    read_strm ( &read_strmbuf )
{
  if (!write_strm.good())
    errorlog << "TrainerConnection: connection seems to have failed" << ende;
}

TrainerConnection::~TrainerConnection()
{
}


bool
TrainerConnection::initializeConnection()
{
  if (!sendToServer("(init (version 9.00))"))
    return false;
  if (!sendToServer("(eye off)"))
    return false;
  if (!sendToServer("(ear off)"))
    return false;

  int errcode = pthread_create(&thrd, NULL, &readStream, this);
  if (errcode != 0)
    {
      errorlog << "Error creating parser thread: " << errcode << ende;
      return false;
    }

  return true;
}

bool
TrainerConnection::sendToServer(const char* s)
{
  actionlog(150) << "TrainerConnection: sending '" << s << "'" << ende;
  write_strm << s << ends << flush;
  return write_strm.good();
}

bool
TrainerConnection::moveBall(const VecPosition& v)
{
  std::ostringstream os;
  os << "(move (ball) " << v.getX() << " " << v.getY() << ")" << ends;
  return sendToServer(os.str().c_str());
}

void
TrainerConnection::printReadStreamTo(std::ostream& os)
{
  
}

//static
void*
TrainerConnection::readStream(void* arg)
{
  TrainerConnection* mythis = static_cast<TrainerConnection*>(arg);
  char buf[10000];
  while (mythis->read_strm)
    {
      mythis->read_strm.getline(buf, 10000);
    }
  return NULL;
}

