/* -*- Mode: C++ -*- */

/* This class provides a code to do basic parsing and such of a Abstract State
   file (generated by ModAbstract abstract state trackers, per cycle files
   A user of this class provides the actual analysis of the date
   This is mostly about parsing */

#ifndef _STATETRACEANALYZER_H_
#define _STATETRACEANALYZER_H_

// The user of StateTraceAnalyzer has to implement this interface
class StateTraceAnalyzerStrategy
{
public:
  StateTraceAnalyzerStrategy() {}
  virtual ~StateTraceAnalyzerStrategy() {}

  //called at beginning of processing a list of files
  virtual void startFileList(const char* fn) = 0;
  
  //called at the beginning of every file of state transitions
  virtual void startFile(const char* fn) = 0;

  // THe main callback: inside of each file, called for each state trace element
  // Also remembers previous times and states, just for conveinance
  // -1 means invalid for last_state, last_tiem
  virtual void handleNextState(int last_time, int last_state, int time, int state) = 0;

  //called at the end of every file analysis
  virtual void endFile(const char* fn) = 0;

  //called at end of processing a list of files
  virtual void endFileList(const char* fn) = 0;

};

class StateTraceAnalyzer
{
public:
  //done not take over mem
  StateTraceAnalyzer(StateTraceAnalyzerStrategy* p) : pstrategy(p) {}
  ~StateTraceAnalyzer() {}

  //returns number of files processed
  int processListFile(const char* listfn);

  // returns true on success
  bool processFile(const char* fn);

private:
  StateTraceAnalyzerStrategy* pstrategy;
};


#endif
