/* -*- Mode: C++ -*- */

#include "StateTraceAnalyzer.h"
#include "Logger.h"
#include "utility.h"

using namespace spades;

//returns number of files processed
int
StateTraceAnalyzer::processListFile(const char* listfn)
{
  // The infn is a file which contains lists of other files to read
  std::ifstream is_file_list(listfn);

  if (!is_file_list)
    {
      errorlog << "StateTraceAnalyzer: Could not open file list '" << listfn << "'" << ende;
      return -1;
    }

  actionlog(50) << "StateTraceAnalyzer: processing list file " << listfn << ende;
  pstrategy->startFileList(listfn);

  int count = 0;
  for (;;)
    {
      if (!skip_to_non_comment(is_file_list))
	break;
      std::string fn;
      is_file_list >> fn;
      if (is_file_list.fail())
	break;
      fn = resolvePathGivenStartingFile(listfn, fn.c_str());

      //std::cout << "...Processing: " << fn << std::endl;
      actionlog(50) << "StateTraceAnalyzer: processing " << fn << ende;

      if (processFile(fn.c_str()))
	count++;
    }

  pstrategy->endFileList(listfn);

  return count;
}


// returns true on success
bool
StateTraceAnalyzer::processFile(const char* fn)
{
  std::ifstream is(fn);
  if (!is)
    {
      errorlog << "StateTraceAnalyzer: Could not open file '" << fn << "'" << ende;
      return false;
    }

  pstrategy->startFile(fn);

  int lasttime = -1;
  int laststate = -1;
  for (;;)
    {
      if (!skip_to_non_comment(is))
	break;
      int time, state;
      is >> time;
      if (!skip_to_character(is, ':'))
	break;
      is >> state;
      if (is.fail())
	{
	  errorlog << "StateTraceAnalyzer: Failed reading line" << ende;
	  return false;
	}
      actionlog(210) << "StateTraceAnalyzer: Read line " << time << ": " << state << ende;

      pstrategy->handleNextState(lasttime, laststate, time, state);

      lasttime = time;
      laststate = state;
    }

  pstrategy->endFile(fn);

  return true;
}

