/* -*- Mode: C++ -*- */

/* This is a message builder for a clang parser that sorts the tokens into a
   CoachMessageQueue */

#ifndef _SORTER_MSG_BUILDER_H_
#define _SORTER_MSG_BUILDER_H_

#include "clangmsgbuilder.h"
#include "CoachMessageQueue.h"

class SorterMsgBuilder
  : public rcss::clang::MsgBuilder
{
public:
  //does NOT take over the memory
  SorterMsgBuilder(CoachMessageQueue* pCMQ);
  ~SorterMsgBuilder() {}

  // these redefine methods for MsgBuilder
  void buildMetaMsg();
  void buildDefineMsg();
  void buildFreeformMsg( const std::string& str );
  void buildUnsuppMsg();
  void buildInfoMsg();
  void buildAdviceMsg();
  void buildRuleMsg();
  void buildDelMsg();

  int getDefineElementCnt() const { return define_element_cnt; }
  int getFreeformElementCnt() const { return freeform_element_cnt; }
  int getRuleElementCnt() const { return rule_element_cnt; }
  int getDelElementCnt() const { return del_element_cnt; }

  void resetCounts()
  { define_element_cnt = freeform_element_cnt = rule_element_cnt = del_element_cnt = 0; }
  
private:
  CoachMessageQueue* pCMQ;
  int define_element_cnt;
  int freeform_element_cnt;
  int rule_element_cnt;
  int del_element_cnt;
};










#endif
