
/* This is a message builder for a clang parser that sorts the tokens into a
   CoachMessageQueue */

#include "SorterMsgBuilder.h"
#include "clangmsg.h"
#include "Logger.h"

using namespace spades;
using namespace rcss::clang;

SorterMsgBuilder::SorterMsgBuilder(CoachMessageQueue* pCMQ)
  : rcss::clang::MsgBuilder(),
    pCMQ(pCMQ),
    define_element_cnt(0),
    freeform_element_cnt(0),
    rule_element_cnt(0),
    del_element_cnt(0)
{
}

void
SorterMsgBuilder::buildMetaMsg()
{
  errorlog << "SorterMsgBuilder: I don't support meta" << ende;
  clear();
}

void
SorterMsgBuilder::buildDefineMsg()
{
  //traceBuild< DefineMsg* >();
  if( checkIsItem< Def* >() )
    {
      // we cache them here first because we have to do some order reversing
      std::vector<Def*> def_tokens;
      while( isItem< Def* >() )
	{
	  Def* pDef = getPtrItem< Def >().release();
	  actionlog(180) << "SorterMsgBuilder: sorted a define element: " << *pDef << ende;
	  define_element_cnt++;
	  def_tokens.push_back(pDef);
	}
      for (std::vector<Def*>::reverse_iterator iter = def_tokens.rbegin();
	   iter != def_tokens.rend();
	   iter++)
	pCMQ->getDefineContainer().push( *iter );
    }
}

void
SorterMsgBuilder::buildFreeformMsg( const std::string& str )
{
  actionlog(180) << "SorterMsgBuilder: sorting a freeform: " << str << ende;
  pCMQ->getFreeformContainer().push( new FreeformMsg( str ) );
  freeform_element_cnt++;
}

void
SorterMsgBuilder::buildUnsuppMsg()
{
  errorlog << "SorterMsgBuilder: I don't support unsupported message" << ende;
  clear();
}

void  
SorterMsgBuilder::buildInfoMsg()
{
  errorlog << "SorterMsgBuilder: I don't support info (old clang)" << ende;
  clear();
}

void
SorterMsgBuilder::buildAdviceMsg()
{
  errorlog << "SorterMsgBuilder: I don't support advice (old clang)" << ende;
  clear();  
}

void
SorterMsgBuilder::buildRuleMsg()
{
  //traceBuild< RuleMsg* >();
  if( checkIsItem< ActivateRules >() )
    {
      std::vector<ActivateRules*> rule_tokens;
      while( isItem< ActivateRules >() )
	{
	  ActivateRules* p = new ActivateRules( getItem< ActivateRules >() );
	  actionlog(180) << "SorterMsgBuilder: sorting a rule element: " << *p << ende;
	  rule_tokens.push_back(p);
	  rule_element_cnt++;
	}
      for (std::vector<ActivateRules*>::reverse_iterator iter = rule_tokens.rbegin();
	   iter != rule_tokens.rend();
	   iter++)
	pCMQ->getRuleContainer().push( *iter );
    }
}

void
SorterMsgBuilder::buildDelMsg()
{
  //traceBuild< DelMsg* >();
  if( isItem< RuleID >() )
    {
      RuleIDList* prids = new RuleIDList;
      prids->push_front( getItem< RuleID >() );
      actionlog(180) << "SorterMsgBuilder: sorting a single rule del: " << *prids << ende;
      pCMQ->getDelContainer().push ( prids );
      del_element_cnt++;
    }
  else
    {
      // we have to do this copy because previously the memory was not dynamically allocated
      RuleIDList* prids = new RuleIDList(checkAndGetItem< RuleIDList >());
      actionlog(180) << "SorterMsgBuilder: sorting a multiple rule del: " << *prids << ende;
      pCMQ->getDelContainer().push ( prids );
      del_element_cnt++;
    }
}

