/* -*- Mode: C++ -*- */

/* a simple control loop that calls the modules once */
#ifndef _SINGLE_CALL_RUNNER_H_
#define _SINGLE_CALL_RUNNER_H_

#include "Runner.h"

class SingleCallRunner
  : public Runner
{
public:
  SingleCallRunner(ModuleRegistry* pReg) : Runner(pReg), shutdown(false) {}
  ~SingleCallRunner() {}

  // this method should call all of the the dependency check methods of the appropriate
  // type
  bool dependencyCheck(ModuleRegistry* pReg);
  
  // the method to enter the loop and do all the work
  bool run();

  // This is public so that Modules can take the addr of it to pass around
  // as an early term request
  bool shutdown;
  
protected:
  void prot_initiateShutdown() { shutdown = true; }

private:

};



#endif
