/* a simple control loop that calls the modules once */

#include "SingleCallRunner.h"
#include "Module.h"
#include "ModuleRegistry.h"
#include "Logger.h"

class SingleCaller : std::unary_function<Module*,void>
{
public:
  SingleCaller(SingleCallRunner* p) : p(p) {}
  void operator() (Module* m)
  {
    actionlog(10) << "Calling module: " << m->getName() << spades::ende;
    m->singleCall(*p);
  }
private:
  SingleCallRunner* p;
};

// this method should call all of the the dependency check methods of the appropriate
// type
bool
SingleCallRunner::dependencyCheck(ModuleRegistry* pReg)
{
  DependencyCaller<SingleCallRunner> caller(pReg, *this);
  for_each(pReg->getStorage().begin(), pReg->getStorage().end(), caller);
  return getDependencySuccess();
}

bool
SingleCallRunner::run()
{
  for_each(pReg->getStorage().begin(), pReg->getStorage().end(), SingleCaller(this));
  return true;
}

