/* -*- Mode: c++ -*- */

#ifndef _SERVERPARAM_H_
#define _SERVERPARAM_H_

#include "ParamReader.h"
#include "Geometry.h"

class ServerParam
  : public spades::ParamReader
{
public:

  ServerParam ();
  virtual ~ ServerParam ();

  static ServerParam* instance() { return s_instance; }

private:
  static ServerParam* s_instance;
    
protected:
  //virtual void writeConfig ( ostream& o ) = 0;

  virtual void addAll2Maps ();
  virtual void setDefaultValues ();
  virtual void postReadProcessing ();

public:

  int getSPCatchBanCycle() const { return catch_ban_cycle; }
  int getSPClangAdviceWin() const { return clang_advice_win; }
  int getSPClangDefineWin() const { return clang_define_win; }
  int getSPClangDelWin() const { return clang_del_win; }
  int getSPClangInfoWin() const { return clang_info_win; }
  int getSPClangMessDelay() const { return clang_mess_delay; }
  int getSPClangMessPerCycle() const { return clang_mess_per_cycle; }
  int getSPClangMetaWin() const { return clang_meta_win; }
  int getSPClangRuleWin() const { return clang_rule_win; }
  int getSPClangWinSize() const { return clang_win_size; }
  int getSPCoachPort() const { return coach_port; }
  int getSPConnectWait() const { return connect_wait; }
  int getSPDropBallTime() const { return drop_ball_time; }
  int getSPFreeformSendPeriod() const { return freeform_send_period; }
  int getSPFreeformWaitPeriod() const { return freeform_wait_period; }
  int getSPGameLogCompression() const { return game_log_compression; }
  int getSPGameLogVersion() const { return game_log_version; }
  int getSPGameOverWait() const { return game_over_wait; }
  int getSPGoalieMaxMoves() const { return goalie_max_moves; }
  int getSPHalfTime() const { return half_time; }
  int getSPHearDecay() const { return hear_decay; }
  int getSPHearInc() const { return hear_inc; }
  int getSPHearMax() const { return hear_max; }
  int getSPKeepawayStart() const { return keepaway_start; }
  int getSPKickOffWait() const { return kick_off_wait; }
  int getSPMaxGoalKicks() const { return max_goal_kicks; }
  int getSPNrExtraHalfs() const { return nr_extra_halfs; }
  int getSPNrNormalHalfs() const { return nr_normal_halfs; }
  int getSPOlcoachPort() const { return olcoach_port; }
  int getSPPenBeforeSetupWait() const { return pen_before_setup_wait; }
  int getSPPenMaxExtraKicks() const { return pen_max_extra_kicks; }
  int getSPPenNrKicks() const { return pen_nr_kicks; }
  int getSPPenReadyWait() const { return pen_ready_wait; }
  int getSPPenSetupWait() const { return pen_setup_wait; }
  int getSPPenTakenWait() const { return pen_taken_wait; }
  int getSPPointToBan() const { return point_to_ban; }
  int getSPPointToDuration() const { return point_to_duration; }
  int getSPPort() const { return port; }
  int getSPRecvStep() const { return recv_step; }
  int getSPSayCoachCntMax() const { return say_coach_cnt_max; }
  int getSPSayCoachMsgSize() const { return say_coach_msg_size; }
  int getSPSayMsgSize() const { return say_msg_size; }
  int getSPSendStep() const { return send_step; }
  int getSPSendViStep() const { return send_vi_step; }
  int getSPSenseBodyStep() const { return sense_body_step; }
  int getSPSimulatorStep() const { return simulator_step; }
  int getSPSlowDownFactor() const { return slow_down_factor; }
  int getSPStartGoalL() const { return start_goal_l; }
  int getSPStartGoalR() const { return start_goal_r; }
  int getSPSynchMicroSleep() const { return synch_micro_sleep; }
  int getSPSynchOffset() const { return synch_offset; }
  int getSPTackleCycles() const { return tackle_cycles; }
  int getSPTextLogCompression() const { return text_log_compression; }
  std::string getSPGameLogDir() const { return game_log_dir; }
  std::string getSPGameLogFixedName() const { return game_log_fixed_name; }
  std::string getSPKeepawayLogDir() const { return keepaway_log_dir; }
  std::string getSPKeepawayLogFixedName() const { return keepaway_log_fixed_name; }
  std::string getSPLandmarkFile() const { return landmark_file; }
  std::string getSPLogDateFormat() const { return log_date_format; }
  std::string getSPTeamLStart() const { return team_l_start; }
  std::string getSPTeamRStart () const { return team_r_start; }
  std::string getSPTextLogDir() const { return text_log_dir; }
  std::string getSPTextLogFixedName() const { return text_log_fixed_name; }
  int getSPCoach() const { return coach; }
  int getSPCoachWReferee() const { return coach_w_referee; }
  int getSPOldCoachHear() const { return old_coach_hear; }
  int getSPWindNone() const { return wind_none; }
  int getSPWindRandom() const { return wind_random; }
  int getSPAutoMode() const { return auto_mode; }
  int getSPBackPasses() const { return back_passes; }
  int getSPForbidKickOffOffside() const { return forbid_kick_off_offside; }
  int getSPFreeKickFaults() const { return free_kick_faults; }
  int getSPFullstateL() const { return fullstate_l; }
  int getSPFullstateR() const { return fullstate_r; }
  int getSPGameLogDated() const { return game_log_dated; }
  int getSPGameLogFixed() const { return game_log_fixed; }
  int getSPGameLogging() const { return game_logging; }
  int getSPKeepaway() const { return keepaway; }
  int getSPKeepawayLogDated() const { return keepaway_log_dated; }
  int getSPKeepawayLogFixed() const { return keepaway_log_fixed; }
  int getSPKeepawayLogging() const { return keepaway_logging; }
  int getSPLogTimes() const { return log_times; }
  int getSPPenAllowMultKicks() const { return pen_allow_mult_kicks; }
  int getSPPenRandomWinner() const { return pen_random_winner; }
  int getSPPenaltyShootOuts() const { return penalty_shoot_outs; }
  int getSPProfile() const { return profile; }
  int getSPProperGoalKicks() const { return proper_goal_kicks; }
  int getSPRecordMessages() const { return record_messages; }
  int getSPSendComms() const { return send_comms; }
  int getSPSynchMode() const { return synch_mode; }
  int getSPTeamActuatorNoise() const { return team_actuator_noise; }
  int getSPTextLogDated() const { return text_log_dated; }
  int getSPTextLogFixed() const { return text_log_fixed; }
  int getSPTextLogging() const { return text_logging; }
  int getSPUseOffside() const { return use_offside; }
  int getSPVerbose() const { return verbose; }
  double getSPAudioCutDist() const { return audio_cut_dist; }
  double getSPBallAccelMax() const { return ball_accel_max; }
  double getSPBallDecay() const { return ball_decay; }
  double getSPBallRand() const { return ball_rand; }
  double getSPBallSize() const { return ball_size; }
  double getSPBallSpeedMax() const { return ball_speed_max; }
  double getSPBallWeight() const { return ball_weight; }
  double getSPCatchProbability() const { return catch_probability; }
  double getSPCatchableAreaL() const { return catchable_area_l; }
  double getSPCatchableAreaW() const { return catchable_area_w; }
  double getSPCkickMargin() const { return ckick_margin; }
  double getSPControlRadius() const { return control_radius; }
  double getSPDashPowerRate() const { return dash_power_rate; }
  double getSPEffortDec() const { return effort_dec; }
  double getSPEffortDecThr() const { return effort_dec_thr; }
  double getSPEffortInc() const { return effort_inc; }
  double getSPEffortIncThr() const { return effort_inc_thr; }
  double getSPEffortInit() const { return effort_init; }
  double getSPEffortMin() const { return effort_min; }
  double getSPGoalWidth() const { return goal_width; }
  double getSPInertiaMoment() const { return inertia_moment; }
  double getSPKeepawayLength() const { return keepaway_length; }
  double getSPKeepawayWidth() const { return keepaway_width; }
  double getSPKickPowerRate() const { return kick_power_rate; }
  double getSPKickRand() const { return kick_rand; }
  double getSPKickRandFactorL() const { return kick_rand_factor_l; }
  double getSPKickRandFactorR() const { return kick_rand_factor_r; }
  double getSPKickableMargin() const { return kickable_margin; }
  double getSPMaxMoment() const { return maxmoment; }
  double getSPMaxNeckAng() const { return maxneckang; }
  double getSPMaxNeckMoment() const { return maxneckmoment; }
  double getSPMaxPower() const { return maxpower; }
  double getSPMinMoment() const { return minmoment; }
  double getSPMinNeckAng() const { return minneckang; }
  double getSPMinNeckMoment() const { return minneckmoment; }
  double getSPMinPower() const { return minpower; }
  double getSPOffsideActiveAreaSize() const { return offside_active_area_size; }
  double getSPOffsideKickMargin() const { return offside_kick_margin; }
  double getSPPenDistX() const { return pen_dist_x; }
  double getSPPenMaxGoalieDistX() const { return pen_max_goalie_dist_x; }
  double getSPPlayerAccelMax() const { return player_accel_max; }
  double getSPPlayerDecay() const { return player_decay; }
  double getSPPlayerRand() const { return player_rand; }
  double getSPPlayerSize() const { return player_size; }
  double getSPPlayerSpeedMax() const { return player_speed_max; }
  double getSPPlayerWeight() const { return player_weight; }
  double getSPPrandFactorL() const { return prand_factor_l; }
  double getSPPrandFactorR() const { return prand_factor_r; }
  double getSPQuantizeStep() const { return quantize_step; }
  double getSPQuantizeStepL() const { return quantize_step_l; }
  double getSPRecoverDec() const { return recover_dec; }
  double getSPRecoverDecThr() const { return recover_dec_thr; }
  double getSPRecoverInit() const { return recover_init; }
  double getSPRecoverMin() const { return recover_min; }
  double getSPSlownessOnTopForLeftTeam() const { return slowness_on_top_for_left_team; }
  double getSPSlownessOnTopForRightTeam() const { return slowness_on_top_for_right_team; }
  double getSPStaminaIncMax() const { return stamina_inc_max; }
  double getSPStaminaMax() const { return stamina_max; }
  double getSPStoppedBallVel() const { return stopped_ball_vel; }
  double getSPTackleBackDist() const { return tackle_back_dist; }
  double getSPTackleDist() const { return tackle_dist; }
  double getSPTackleExponent() const { return tackle_exponent; }
  double getSPTacklePowerRate() const { return tackle_power_rate; }
  double getSPTackleWidth() const { return tackle_width; }
  double getSPVisibleAngle() const { return visible_angle; }
  double getSPVisibleDistance() const { return visible_distance; }
  double getSPWindAng() const { return wind_ang; }
  double getSPWindDir() const { return wind_dir; }
  double getSPWindForce() const { return wind_force; }
  double getSPWindRand() const { return wind_rand; }

  //now calculated values
  double getSPKickableArea() const { return kickable_area; }
  int getSPHalfCycles() const { return half_cycles; }
  const Rectangle& getSPFieldRectangle() const { return field_rectangle; }
  const Rectangle& getSPPenaltyAreaRectangle(bool left)
  { return left ? left_penalty_area : right_penalty_area; }
  const Rectangle& getSPGoalAreaRectangle(bool left)
  { return left ? left_goal_area : right_goal_area; }
  const VecPosition& getSPGoalPos(bool left)
  { return left ? left_goal : right_goal; }
  
  //now things the server does not actually have, but I consider server params
  int getSPTeamSize() const { return team_size; }
  double getSPPitchLength() const { return pitch_length; }
  double getSPPitchWidth() const { return pitch_width; }
  double getSPPenaltyAreaLength() const { return penalty_area_length; }
  double getSPPenaltyAreaWidth() const { return penalty_area_width; }
  double getSPGoalAreaLength() const { return goal_area_length; }
  double getSPGoalAreaWidth() const { return goal_area_width; }
  double getSPPenaltySpotDist() const { return penalty_spot_dist; }
  double getSPCornerArcR() const { return corner_arc_r; }

  //When we get params from the server the half cycles gets calculated
  // incorrectly if slow_down_factor is not 1. This calculates correctly
  void fixSPHalfCyclesFromServer();
  
protected:

  int catch_ban_cycle;
  int clang_advice_win;
  int clang_define_win;
  int clang_del_win;
  int clang_info_win;
  int clang_mess_delay;
  int clang_mess_per_cycle;
  int clang_meta_win;
  int clang_rule_win;
  int clang_win_size;
  int coach_port;
  int connect_wait;
  int drop_ball_time;
  int freeform_send_period;
  int freeform_wait_period;
  int game_log_compression;
  int game_log_version;
  int game_over_wait;
  int goalie_max_moves;
  int half_time;
  int hear_decay;
  int hear_inc;
  int hear_max;
  int keepaway_start;
  int kick_off_wait;
  int max_goal_kicks;
  int nr_extra_halfs;
  int nr_normal_halfs;
  int olcoach_port;
  int pen_before_setup_wait;
  int pen_max_extra_kicks;
  int pen_nr_kicks;
  int pen_ready_wait;
  int pen_setup_wait;
  int pen_taken_wait;
  int point_to_ban;
  int point_to_duration;
  int port;
  int recv_step;
  int say_coach_cnt_max;
  int say_coach_msg_size;
  int say_msg_size;
  int send_step;
  int send_vi_step;
  int sense_body_step;
  int simulator_step;
  int slow_down_factor;
  int start_goal_l;
  int start_goal_r;
  int synch_micro_sleep;
  int synch_offset;
  int tackle_cycles;
  int text_log_compression;
  std::string game_log_dir;
  std::string game_log_fixed_name;
  std::string keepaway_log_dir;
  std::string keepaway_log_fixed_name;
  std::string landmark_file;
  std::string log_date_format;
  std::string team_l_start;
  std::string team_r_start;
  std::string text_log_dir;
  std::string text_log_fixed_name;
  int coach;
  int coach_w_referee;
  int old_coach_hear;
  int wind_none;
  int wind_random;
  int auto_mode;
  int back_passes;
  int forbid_kick_off_offside;
  int free_kick_faults;
  int fullstate_l;
  int fullstate_r;
  int game_log_dated;
  int game_log_fixed;
  int game_logging;
  int keepaway;
  int keepaway_log_dated;
  int keepaway_log_fixed;
  int keepaway_logging;
  int log_times;
  int pen_allow_mult_kicks;
  int pen_random_winner;
  int penalty_shoot_outs;
  int profile;
  int proper_goal_kicks;
  int record_messages;
  int send_comms;
  int synch_mode;
  int team_actuator_noise;
  int text_log_dated;
  int text_log_fixed;
  int text_logging;
  int use_offside;
  int verbose;
  double audio_cut_dist;
  double ball_accel_max;
  double ball_decay;
  double ball_rand;
  double ball_size;
  double ball_speed_max;
  double ball_weight;
  double catch_probability;
  double catchable_area_l;
  double catchable_area_w;
  double ckick_margin;
  double control_radius;
  double dash_power_rate;
  double effort_dec;
  double effort_dec_thr;
  double effort_inc;
  double effort_inc_thr;
  double effort_init;
  double effort_min;
  double goal_width;
  double inertia_moment;
  double keepaway_length;
  double keepaway_width;
  double kick_power_rate;
  double kick_rand;
  double kick_rand_factor_l;
  double kick_rand_factor_r;
  double kickable_margin;
  double maxmoment;
  double maxneckang;
  double maxneckmoment;
  double maxpower;
  double minmoment;
  double minneckang;
  double minneckmoment;
  double minpower;
  double offside_active_area_size;
  double offside_kick_margin;
  double pen_dist_x;
  double pen_max_goalie_dist_x;
  double player_accel_max;
  double player_decay;
  double player_rand;
  double player_size;
  double player_speed_max;
  double player_weight;
  double prand_factor_l;
  double prand_factor_r;
  double quantize_step;
  double quantize_step_l;
  double recover_dec;
  double recover_dec_thr;
  double recover_init;
  double recover_min;
  double slowness_on_top_for_left_team;
  double slowness_on_top_for_right_team;
  double stamina_inc_max;
  double stamina_max;
  double stopped_ball_vel;
  double tackle_back_dist;
  double tackle_dist;
  double tackle_exponent;
  double tackle_power_rate;
  double tackle_width;
  double visible_angle;
  double visible_distance;
  double wind_ang;
  double wind_dir;
  double wind_force;
  double wind_rand;

  //now calculated values
  double kickable_area;
  int half_cycles;
  Rectangle field_rectangle;
  Rectangle left_penalty_area;
  Rectangle right_penalty_area;
  Rectangle left_goal_area;
  Rectangle right_goal_area;
  VecPosition left_goal;
  VecPosition right_goal;
  
  //now things the server does not actually have, but I consider server params
  int team_size;
  double pitch_length;
  double pitch_width;
  double penalty_area_length;
  double penalty_area_width;
  double goal_area_length;
  double goal_area_width;
  double penalty_spot_dist;
  double corner_arc_r;

  
};

#endif
