/* -*- Mode: c++ -*- */

#include <sstream>
#include "ServerParam.h"
#include "Logger.h"
#include "version.h"

using namespace spades;

ServerParam* ServerParam::s_instance = NULL;

ServerParam::ServerParam ()
  : ParamReader(g_Version)
{
  if (s_instance)
    errorlog << "Should only be one instance of ServerParam" << ende;
  s_instance = this;
}

ServerParam::~ServerParam ()
{
  s_instance = NULL;
}

void
ServerParam::addAll2Maps ()
{

  add2Maps("catch_ban_cycle", &catch_ban_cycle);
  add2Maps("clang_advice_win", &clang_advice_win);
  add2Maps("clang_define_win", &clang_define_win);
  add2Maps("clang_del_win", &clang_del_win);
  add2Maps("clang_info_win", &clang_info_win);
  add2Maps("clang_mess_delay", &clang_mess_delay);
  add2Maps("clang_mess_per_cycle", &clang_mess_per_cycle);
  add2Maps("clang_meta_win", &clang_meta_win);
  add2Maps("clang_rule_win", &clang_rule_win);
  add2Maps("clang_win_size", &clang_win_size);
  add2Maps("coach_port", &coach_port);
  add2Maps("connect_wait", &connect_wait);
  add2Maps("drop_ball_time", &drop_ball_time);
  add2Maps("freeform_send_period", &freeform_send_period);
  add2Maps("freeform_wait_period", &freeform_wait_period);
  add2Maps("game_log_compression", &game_log_compression);
  add2Maps("game_log_version", &game_log_version);
  add2Maps("game_over_wait", &game_over_wait);
  add2Maps("goalie_max_moves", &goalie_max_moves);
  add2Maps("half_time", &half_time);
  add2Maps("hear_decay", &hear_decay);
  add2Maps("hear_inc", &hear_inc);
  add2Maps("hear_max", &hear_max);
  add2Maps("keepaway_start", &keepaway_start);
  add2Maps("kick_off_wait", &kick_off_wait);
  add2Maps("max_goal_kicks", &max_goal_kicks);
  add2Maps("nr_extra_halfs", &nr_extra_halfs);
  add2Maps("nr_normal_halfs", &nr_normal_halfs);
  add2Maps("olcoach_port", &olcoach_port);
  add2Maps("pen_before_setup_wait", &pen_before_setup_wait);
  add2Maps("pen_max_extra_kicks", &pen_max_extra_kicks);
  add2Maps("pen_nr_kicks", &pen_nr_kicks);
  add2Maps("pen_ready_wait", &pen_ready_wait);
  add2Maps("pen_setup_wait", &pen_setup_wait);
  add2Maps("pen_taken_wait", &pen_taken_wait);
  add2Maps("point_to_ban", &point_to_ban);
  add2Maps("point_to_duration", &point_to_duration);
  add2Maps("port", &port);
  add2Maps("recv_step", &recv_step);
  add2Maps("say_coach_cnt_max", &say_coach_cnt_max);
  add2Maps("say_coach_msg_size", &say_coach_msg_size);
  add2Maps("say_msg_size", &say_msg_size);
  add2Maps("send_step", &send_step);
  add2Maps("send_vi_step", &send_vi_step);
  add2Maps("sense_body_step", &sense_body_step);
  add2Maps("simulator_step", &simulator_step);
  add2Maps("slow_down_factor", &slow_down_factor);
  add2Maps("start_goal_l", &start_goal_l);
  add2Maps("start_goal_r", &start_goal_r);
  add2Maps("synch_micro_sleep", &synch_micro_sleep);
  add2Maps("synch_offset", &synch_offset);
  add2Maps("tackle_cycles", &tackle_cycles);
  add2Maps("text_log_compression", &text_log_compression);
  add2Maps("game_log_dir", &game_log_dir);
  add2Maps("game_log_fixed_name", &game_log_fixed_name);
  add2Maps("keepaway_log_dir", &keepaway_log_dir);
  add2Maps("keepaway_log_fixed_name", &keepaway_log_fixed_name);
  add2Maps("landmark_file", &landmark_file);
  add2Maps("log_date_format", &log_date_format);
  add2Maps("team_l_start", &team_l_start);
  add2Maps("team_r_start", &team_r_start);
  add2Maps("text_log_dir", &text_log_dir);
  add2Maps("text_log_fixed_name", &text_log_fixed_name);
  add2Maps("coach", &coach);
  add2Maps("coach_w_referee", &coach_w_referee);
  add2Maps("old_coach_hear", &old_coach_hear);
  add2Maps("wind_none", &wind_none);
  add2Maps("wind_random", &wind_random);
  add2Maps("auto_mode", &auto_mode);
  add2Maps("back_passes", &back_passes);
  add2Maps("forbid_kick_off_offside", &forbid_kick_off_offside);
  add2Maps("free_kick_faults", &free_kick_faults);
  add2Maps("fullstate_l", &fullstate_l);
  add2Maps("fullstate_r", &fullstate_r);
  add2Maps("game_log_dated", &game_log_dated);
  add2Maps("game_log_fixed", &game_log_fixed);
  add2Maps("game_logging", &game_logging);
  add2Maps("keepaway", &keepaway);
  add2Maps("keepaway_log_dated", &keepaway_log_dated);
  add2Maps("keepaway_log_fixed", &keepaway_log_fixed);
  add2Maps("keepaway_logging", &keepaway_logging);
  add2Maps("log_times", &log_times);
  add2Maps("pen_allow_mult_kicks", &pen_allow_mult_kicks);
  add2Maps("pen_random_winner", &pen_random_winner);
  add2Maps("penalty_shoot_outs", &penalty_shoot_outs);
  add2Maps("profile", &profile);
  add2Maps("proper_goal_kicks", &proper_goal_kicks);
  add2Maps("record_messages", &record_messages);
  add2Maps("send_comms", &send_comms);
  add2Maps("synch_mode", &synch_mode);
  add2Maps("team_actuator_noise", &team_actuator_noise);
  add2Maps("text_log_dated", &text_log_dated);
  add2Maps("text_log_fixed", &text_log_fixed);
  add2Maps("text_logging", &text_logging);
  add2Maps("use_offside", &use_offside);
  add2Maps("verbose", &verbose);
  add2Maps("audio_cut_dist", &audio_cut_dist);
  add2Maps("ball_accel_max", &ball_accel_max);
  add2Maps("ball_decay", &ball_decay);
  add2Maps("ball_rand", &ball_rand);
  add2Maps("ball_size", &ball_size);
  add2Maps("ball_speed_max", &ball_speed_max);
  add2Maps("ball_weight", &ball_weight);
  add2Maps("catch_probability", &catch_probability);
  add2Maps("catchable_area_l", &catchable_area_l);
  add2Maps("catchable_area_w", &catchable_area_w);
  add2Maps("ckick_margin", &ckick_margin);
  add2Maps("control_radius", &control_radius);
  add2Maps("dash_power_rate", &dash_power_rate);
  add2Maps("effort_dec", &effort_dec);
  add2Maps("effort_dec_thr", &effort_dec_thr);
  add2Maps("effort_inc", &effort_inc);
  add2Maps("effort_inc_thr", &effort_inc_thr);
  add2Maps("effort_init", &effort_init);
  add2Maps("effort_min", &effort_min);
  add2Maps("goal_width", &goal_width);
  add2Maps("inertia_moment", &inertia_moment);
  add2Maps("keepaway_length", &keepaway_length);
  add2Maps("keepaway_width", &keepaway_width);
  add2Maps("kick_power_rate", &kick_power_rate);
  add2Maps("kick_rand", &kick_rand);
  add2Maps("kick_rand_factor_l", &kick_rand_factor_l);
  add2Maps("kick_rand_factor_r", &kick_rand_factor_r);
  add2Maps("kickable_margin", &kickable_margin);
  add2Maps("maxmoment", &maxmoment);
  add2Maps("maxneckang", &maxneckang);
  add2Maps("maxneckmoment", &maxneckmoment);
  add2Maps("maxpower", &maxpower);
  add2Maps("minmoment", &minmoment);
  add2Maps("minneckang", &minneckang);
  add2Maps("minneckmoment", &minneckmoment);
  add2Maps("minpower", &minpower);
  add2Maps("offside_active_area_size", &offside_active_area_size);
  add2Maps("offside_kick_margin", &offside_kick_margin);
  add2Maps("pen_dist_x", &pen_dist_x);
  add2Maps("pen_max_goalie_dist_x", &pen_max_goalie_dist_x);
  add2Maps("player_accel_max", &player_accel_max);
  add2Maps("player_decay", &player_decay);
  add2Maps("player_rand", &player_rand);
  add2Maps("player_size", &player_size);
  add2Maps("player_speed_max", &player_speed_max);
  add2Maps("player_weight", &player_weight);
  add2Maps("prand_factor_l", &prand_factor_l);
  add2Maps("prand_factor_r", &prand_factor_r);
  add2Maps("quantize_step", &quantize_step);
  add2Maps("quantize_step_l", &quantize_step_l);
  add2Maps("recover_dec", &recover_dec);
  add2Maps("recover_dec_thr", &recover_dec_thr);
  add2Maps("recover_init", &recover_init);
  add2Maps("recover_min", &recover_min);
  add2Maps("slowness_on_top_for_left_team", &slowness_on_top_for_left_team);
  add2Maps("slowness_on_top_for_right_team", &slowness_on_top_for_right_team);
  add2Maps("stamina_inc_max", &stamina_inc_max);
  add2Maps("stamina_max", &stamina_max);
  add2Maps("stopped_ball_vel", &stopped_ball_vel);
  add2Maps("tackle_back_dist", &tackle_back_dist);
  add2Maps("tackle_dist", &tackle_dist);
  add2Maps("tackle_exponent", &tackle_exponent);
  add2Maps("tackle_power_rate", &tackle_power_rate);
  add2Maps("tackle_width", &tackle_width);
  add2Maps("visible_angle", &visible_angle);
  add2Maps("visible_distance", &visible_distance);
  add2Maps("wind_ang", &wind_ang);
  add2Maps("wind_dir", &wind_dir);
  add2Maps("wind_force", &wind_force);
  add2Maps("wind_rand", &wind_rand);

  //now things the server does not actually have, but I consider server params
  add2Maps("team_size", &team_size);
  add2Maps("pitch_length", &pitch_length);
  add2Maps("pitch_width", &pitch_width);
  add2Maps ("penalty_area_length", &penalty_area_length);
  add2Maps ("penalty_area_width", &penalty_area_width);
  add2Maps ("goal_area_length", &goal_area_length);
  add2Maps ("goal_area_width", &goal_area_width);
  add2Maps ("penalty_spot_dist", &penalty_spot_dist);
  add2Maps ("corner_arc_r", &corner_arc_r);
}

void
ServerParam::setDefaultValues ()
{
  catch_ban_cycle = 5;
  clang_advice_win = 1;
  clang_define_win = 1;
  clang_del_win = 1;
  clang_info_win = 1;
  clang_mess_delay = 50;
  clang_mess_per_cycle = 1;
  clang_meta_win = 1;
  clang_rule_win = 1;
  clang_win_size = 300;
  coach_port = 6001;
  connect_wait = 300;
  drop_ball_time = 200;
  freeform_send_period = 20;
  freeform_wait_period = 600;
  game_log_compression = 0;
  game_log_version = 3;
  game_over_wait = 100;
  goalie_max_moves = 2;
  half_time = 3000;
  hear_decay = 1;
  hear_inc = 1;
  hear_max = 1;
  keepaway_start = -1;
  kick_off_wait = 100;
  max_goal_kicks = 3;
  nr_extra_halfs = 2;
  nr_normal_halfs = 2;
  olcoach_port = 6002;
  pen_before_setup_wait = 30;
  pen_max_extra_kicks = 10;
  pen_nr_kicks = 5;
  pen_ready_wait = 50;
  pen_setup_wait = 100;
  pen_taken_wait = 100;
  point_to_ban = 5;
  point_to_duration = 20;
  port = 6000;
  recv_step = 10;
  say_coach_cnt_max = 128;
  say_coach_msg_size = 128;
  say_msg_size = 10;
  send_step = 150;
  send_vi_step = 100;
  sense_body_step = 100;
  simulator_step = 100;
  slow_down_factor = 1;
  start_goal_l = 0;
  start_goal_r = 0;
  synch_micro_sleep = 1;
  synch_offset = 60;
  tackle_cycles = 10;
  text_log_compression = 0;
  game_log_dir = "./";
  game_log_fixed_name = "rcssserver";
  keepaway_log_dir = "./";
  keepaway_log_fixed_name = "rcssserver";
  landmark_file = "~/.rcssserver-landmark.xml";
  log_date_format = "%Y%m%d%H%M-";
  team_l_start = "";
  team_r_start = "";
  text_log_dir = "./";
  text_log_fixed_name = "rcssserver";
  coach = 0;
  coach_w_referee = 0;
  old_coach_hear = 0;
  wind_none = 0;
  wind_random = 0;
  auto_mode = 0;
  back_passes = 1;
  forbid_kick_off_offside = 1;
  free_kick_faults = 1;
  fullstate_l = 0;
  fullstate_r = 0;
  game_log_dated = 1;
  game_log_fixed = 0;
  game_logging = 1;
  keepaway = 0;
  keepaway_log_dated = 1;
  keepaway_log_fixed = 0;
  keepaway_logging = 1;
  log_times = 0;
  pen_allow_mult_kicks = 0;
  pen_random_winner = 0;
  penalty_shoot_outs = 1;
  profile = 0;
  proper_goal_kicks = 0;
  record_messages = 0;
  send_comms = 0;
  synch_mode = 0;
  team_actuator_noise = 0;
  text_log_dated = 1;
  text_log_fixed = 0;
  text_logging = 1;
  use_offside = 1;
  verbose = 0;
  audio_cut_dist = 50;
  ball_accel_max = 2.7;
  ball_decay = 0.94;
  ball_rand = 0.05;
  ball_size = 0.085;
  ball_speed_max = 2.7;
  ball_weight = 0.2;
  catch_probability = 1;
  catchable_area_l = 2;
  catchable_area_w = 1;
  ckick_margin = 1;
  control_radius = 2;
  dash_power_rate = 0.006;
  effort_dec = 0.005;
  effort_dec_thr = 0.3;
  effort_inc = 0.01;
  effort_inc_thr = 0.6;
  effort_init = 1;
  effort_min = 0.6;
  goal_width = 14.02;
  inertia_moment = 5;
  keepaway_length = 20;
  keepaway_width = 20;
  kick_power_rate = 0.027;
  kick_rand = 0;
  kick_rand_factor_l = 1;
  kick_rand_factor_r = 1;
  kickable_margin = 0.7;
  maxmoment = 180;
  maxneckang = 90;
  maxneckmoment = 180;
  maxpower = 100;
  minmoment = -180;
  minneckang = -90;
  minneckmoment = -180;
  minpower = -100;
  offside_active_area_size = 2.5;
  offside_kick_margin = 9.15;
  pen_dist_x = 11;
  pen_max_goalie_dist_x = 4;
  player_accel_max = 1;
  player_decay = 0.4;
  player_rand = 0.1;
  player_size = 0.3;
  player_speed_max = 1.2;
  player_weight = 60;
  prand_factor_l = 1;
  prand_factor_r = 1;
  quantize_step = 0.1;
  quantize_step_l = 0.01;
  recover_dec = 0.002;
  recover_dec_thr = 0.3;
  recover_init = 1;
  recover_min = 0.5;
  slowness_on_top_for_left_team = 1;
  slowness_on_top_for_right_team = 1;
  stamina_inc_max = 45;
  stamina_max = 4000;
  stopped_ball_vel = 0.01;
  tackle_back_dist = 0.5;
  tackle_dist = 2.5;
  tackle_exponent = 6;
  tackle_power_rate = 0.027;
  tackle_width = 1.25;
  visible_angle = 90;
  visible_distance = 3;
  wind_ang = 0;
  wind_dir = 0;
  wind_force = 0;
  wind_rand = 0;

  //now things the server does not actually have, but I consider server params
  team_size = 11;
  pitch_length = 105.0;
  pitch_width = 68.0;
  penalty_area_length  = 16.5;
  penalty_area_width   = 40.32;
  goal_area_length	  = 5.5;
  goal_area_width	  = 18.32;
  penalty_spot_dist    = 11.0;
  corner_arc_r	  = 1.0;
}

void
ServerParam::postReadProcessing()
{
  kickable_area = player_size + ball_size + kickable_margin;
  half_cycles = half_time * 1000 / simulator_step;
  field_rectangle = Rectangle(VecPosition(-pitch_length/2.0, -pitch_width/2.0),
			      VecPosition( pitch_length/2.0,  pitch_width/2.0));
  left_penalty_area = Rectangle(VecPosition(-pitch_length/2,
					    -penalty_area_width/2),
				VecPosition(-pitch_length/2 + penalty_area_length, 
					    penalty_area_width/2));
  right_penalty_area = Rectangle(VecPosition(pitch_length/2,
					     -penalty_area_width/2),
				 VecPosition(pitch_length/2 - penalty_area_length, 
					     penalty_area_width/2));
  left_goal_area = Rectangle(VecPosition(-pitch_length/2,
					 -goal_area_width/2),
			     VecPosition(-pitch_length/2 + goal_area_length,
					 goal_area_width/2));
  right_goal_area = Rectangle(VecPosition(pitch_length/2,
					  -goal_area_width/2),
			      VecPosition(pitch_length/2 - goal_area_length,
					  goal_area_width/2));
  left_goal  = VecPosition(-pitch_length / 2, 0);
  right_goal = VecPosition( pitch_length / 2, 0);
}


//When we get params from the server the half cycles gets calculated
// incorrectly if slow_down_factor is not 1. This calculates correctly
void
ServerParam::fixSPHalfCyclesFromServer()
{
  /* I used to have to correct for this, but now the server seems to be doing it
     right.
     THis might be from the fix that I made. For now, I'm just going to do nothing
  */
  actionlog(100) << "Not correcting half_cycles: " << half_cycles
		 << " with sim_step=" << simulator_step
		 << ", slow=" << slow_down_factor
		 << ", half_time=" << half_time
		 << ende;
  /*
  actionlog(100) << "Correcting half_cycles: was " << half_cycles
		 << " with sim_step=" << simulator_step
		 << ", slow=" << slow_down_factor
		 << ", half_time=" << half_time;
  // The server also multipled half_time out it seems!
  half_cycles = half_time;
  actionlog(100) << "; NEW " << half_cycles << ende;
  */
}

