/* -*- Mode: C++ -*- */

/* this class is the basic control loop. Subclasses can implement particular kinds of control */
/* This is here so that Modules can give feedback to the running process */

#ifndef _RUNNER_H_
#define _RUNNER_H_

#include "Logger.h"

class ModuleRegistry;
class Module;

class Runner
{
public:
  Runner(ModuleRegistry* pReg) : pReg(pReg), shutdown_request(false), dependency_success(true) {}
  virtual ~Runner() {}

  // callbacks for the Modules
  void initiateShutdown() { shutdown_request = true; prot_initiateShutdown(); }
  bool isShutdownRequested() const { return shutdown_request; }

  // this method should call all of the the dependency check methods of the appropriate
  // type
  virtual bool dependencyCheck(ModuleRegistry* pReg) = 0;
  
  // the method to enter the loop and do all the work
  virtual bool run() = 0;

  bool getDependencySuccess() const { return dependency_success; }
  void setDependencySuccess(bool val) { dependency_success = val; }
  
protected:
  virtual void prot_initiateShutdown() {}
  
  ModuleRegistry* pReg;

private:
  bool shutdown_request;
  bool dependency_success;
  
};

template <class X>
class DependencyCaller
{
public:
  DependencyCaller(ModuleRegistry* pReg, X& x) : pReg(pReg), x(x) {}
  void operator() (Module* m)
  {
    if (!m->dependencyCheck(pReg, x))
      {
	errorlog << "Module '" << m->getName() << "' failed dependency check" << spades::ende;
        x.setDependencySuccess(false);
      }
  }
  
private:
  
  ModuleRegistry* pReg;
  X& x;
  
};




#endif
