/* -*- Mode: C++ -*- */

/* THis is a QTable which can support different number of actions per state */
#ifndef _Q_TABLE_FLEX_H_
#define _Q_TABLE_FLEX_H_

#include "QTable.h"

class MDP;

class QTableFlex
  : public QTable
{
public:
  QTableFlex(int num_states, float gamma);
  QTableFlex(const MDP& mdp, float gamma);
  ~QTableFlex();

  void setSizeFrom(const MDP& mdp);

  void clear() { qtable.clear(); }
  
  //zeros all ENABLED actions
  void zero();
  
  int getNumActions(int state) const;

  //Format: <num_states> <gamma>
  //Format: then 1 line per state of <num acts> <qvalue> <#visits> <qvalue> <#visits> ...
  friend std::ostream& operator<<(std::ostream& o, const QTableFlex& qt);
  friend std::istream& operator>>(std::istream& i, QTableFlex& qt);

  bool writeTo(BinaryFileWriter& writer) const;
  bool readFrom(BinaryFileReader& reader);

  bool readTextOrBinary(std::istream& is);
  
protected:
  StateActionEntry* getSA(int state, int action);
  const StateActionEntry* getSA(int state, int action) const;
  
  bool checkValid(int state, int action) const;

private:
  typedef std::vector<StateActionEntry> ActionStorage;
  typedef std::vector<ActionStorage>    StateStorage;

  StateStorage qtable;

  static const char* BIN_FILE_MAGIC;
  static const int BIN_FILE_VERSION;
};



#endif
