/* A class describing a policy in this gridworld */

#include <fstream>
#include "Policy.h"
#include "Logger.h"
#include "QTable.h"

using namespace std;
using namespace spades;

Policy::Policy(int num_states)
{
  vAct.resize(num_states, -1);
}

Policy::Policy(const char* fn)
{
  ifstream in(fn);
  if (!in)
    {
      errorlog << "Policy: Could not open file: " << fn << ende;
      return;
    }
  in >> *this;
  if (in.fail() && !in.eof())
    {
      errorlog << "Policy: error reading file: " << fn << ende;
    }
}


Policy::~Policy()
{
}

/*****************************************************************************************/

int
Policy::getAction(unsigned stateidx) const
{
  if (stateidx > vAct.size())
    {
      errorlog << "State is not in my policy: "
	       << stateidx << " > " << vAct.size()
	       << ende;
      return -1;
    }
  return vAct[stateidx]; 
}

/*****************************************************************************************/

void
Policy::setAction(unsigned stateidx, int action)
{
  if (stateidx > vAct.size())
    {
      errorlog << "State is not in my policy: "
	       << stateidx << " > " << vAct.size()
	       << ende;
      return;
    }
  vAct[stateidx] = action;
}


/*****************************************************************************************/

void
Policy::extractFromQTable(const QTable* pQ)
{
  vAct.resize(pQ->getNumStates());
  for (int idx = pQ->getNumStates()-1;
       idx >= 0;
       idx--)
    {
      vAct[idx] = pQ->getActMax(idx);
    }
}

/*****************************************************************************************/

std::ostream&
operator<<(std::ostream& o, const Policy& p)
{
  o << p.vAct.size() << endl;
  
  unsigned int idx;
  vector<int>::const_iterator iter;
  for (idx = 0, iter = p.vAct.begin();
       iter != p.vAct.end();
       idx++, iter++)
    {
      o << idx << ' ' << *iter << endl;
    }

  return o;
}

std::istream&
operator>>(std::istream& is, Policy& p)
{
  int num_states;
  is >> num_states;

  if (!is) return is;

  p.vAct.clear();
  p.vAct.resize(num_states);
  
  unsigned int state;
  int move;
  while (is)
    {
      is >> state >> move;
      if (!is)
	break;
      actionlog(240) << "Read policy line " << state << " " << move << ende;
      p.vAct[state] = move;
    }

  return is;
}

