/* -*- Mode: C++ -*- */

/* This class stores the player types that are available */

#ifndef _PLAYER_TYPES_STORAGE_H_
#define _PLAYER_TYPES_STORAGE_H_

#include <vector>
#include "HeteroPlayerType.h"

class PlayerTypeStorage
{
public:
  PlayerTypeStorage();
  ~PlayerTypeStorage() {}

  const HeteroPlayerType& getPlayerType(int id);

  void addPlayerType(int id, const HeteroPlayerType& ptype);

  friend std::ostream & operator << (std::ostream & o, const PlayerTypeStorage& s);

private:
  typedef std::vector<HeteroPlayerType> PlayerStorage;
  PlayerStorage storage;
  
};



#endif	
