/* This class stores the player types that are available */

#include <iterator>
#include "PlayerTypeStorage.h"
#include "PlayerParam.h"
#include "Logger.h"

using namespace spades;

PlayerTypeStorage::PlayerTypeStorage()
  : storage()
{
  if (PlayerParam::instance())
    storage.reserve(PlayerParam::instance()->getPPPlayerTypes());
}

const HeteroPlayerType&
PlayerTypeStorage::getPlayerType(int id)
{
  if (id < 0 || id >= (signed)storage.size())
    {
      errorlog << "Asked for player type out of range! " << id << " " << storage.size() << ende;
      return storage[0];
    }
  return storage[id];
}


void
PlayerTypeStorage::addPlayerType(int id, const HeteroPlayerType& ptype)
{
  if ((signed)storage.size() < id+1)
    {
      actionlog(150) << "PlayerTypeStorage: resizing for id " << id << ende;
      storage.resize(id+1);
    }
  else 
    {
      warninglog(150) << "PlayerTypeStorage: I seem to already have a spot for id=" << id << ende;
    }
  storage[id] = ptype;
}

std::ostream&
operator<< (std::ostream & o, const PlayerTypeStorage& s)
{
  o << "PlayerTypeStorage: " << std::endl;
  std::copy(s.storage.begin(), s.storage.end(), std::ostream_iterator<HeteroPlayerType>(o, "\n"));
  return o;
}

