/* -*- Mode: c++ -*- */

#ifndef _PLAYERPARAM_H_
#define _PLAYERPARAM_H_

#include "ServerParam.h"

class PlayerParam
  : public ServerParam
{
public:

  PlayerParam ();
  virtual ~ PlayerParam ();

  static PlayerParam* instance() { return s_instance; }

private:
  static PlayerParam* s_instance;
    
protected:
  //virtual void writeConfig ( ostream& o ) = 0;

  virtual void addAll2Maps ();
  virtual void setDefaultValues ();
  virtual void postReadProcessing ();

public:

  int getPPPlayerTypes() const { return player_types; }
  int getPPPtMax() const { return pt_max; }
  int getPPRandomSeed() const { return random_seed; }
  int getPPSubsMax() const { return subs_max; }
  double getPPDashPowerRateDeltaMax() const { return dash_power_rate_delta_max; }
  double getPPDashPowerRateDeltaMin() const { return dash_power_rate_delta_min; }
  double getPPEffortMaxDeltaFactor() const { return effort_max_delta_factor; }
  double getPPEffortMinDeltaFactor() const { return effort_min_delta_factor; }
  double getPPExtraStaminaDeltaMax() const { return extra_stamina_delta_max; }
  double getPPExtraStaminaDeltaMin() const { return extra_stamina_delta_min; }
  double getPPInertiaMomentDeltaFactor() const { return inertia_moment_delta_factor; }
  double getPPKickRandDeltaFactor() const { return kick_rand_delta_factor; }
  double getPPKickableMarginDeltaMax() const { return kickable_margin_delta_max; }
  double getPPKickableMarginDeltaMin() const { return kickable_margin_delta_min; }
  double getPPNewDashPowerRateDeltaMax() const { return new_dash_power_rate_delta_max; }
  double getPPNewDashPowerRateDeltaMin() const { return new_dash_power_rate_delta_min; }
  double getPPNewStaminaIncMaxDeltaFactor() const { return new_stamina_inc_max_delta_factor; }
  double getPPPlayerDecayDeltaMax() const { return player_decay_delta_max; }
  double getPPPlayerDecayDeltaMin() const { return player_decay_delta_min; }
  double getPPPlayerSizeDeltaFactor() const { return player_size_delta_factor; }
  double getPPPlayerSpeedMaxDeltaMax() const { return player_speed_max_delta_max; }
  double getPPPlayerSpeedMaxDeltaMin() const { return player_speed_max_delta_min; }
  double getPPStaminaIncMaxDeltaFactor() const { return stamina_inc_max_delta_factor; }

protected:

  int player_types;
  int pt_max;
  int random_seed;
  int subs_max;
  double dash_power_rate_delta_max;
  double dash_power_rate_delta_min;
  double effort_max_delta_factor;
  double effort_min_delta_factor;
  double extra_stamina_delta_max;
  double extra_stamina_delta_min;
  double inertia_moment_delta_factor;
  double kick_rand_delta_factor;
  double kickable_margin_delta_max;
  double kickable_margin_delta_min;
  double new_dash_power_rate_delta_max;
  double new_dash_power_rate_delta_min;
  double new_stamina_inc_max_delta_factor;
  double player_decay_delta_max;
  double player_decay_delta_min;
  double player_size_delta_factor;
  double player_speed_max_delta_max;
  double player_speed_max_delta_min;
  double stamina_inc_max_delta_factor;

};

#endif
