/* -*- Mode: c++ -*- */

#include <sstream>
#include "PlayerParam.h"
#include "Logger.h"
#include "version.h"

using namespace spades;

PlayerParam* PlayerParam::s_instance = NULL;

PlayerParam::PlayerParam ()
  : ServerParam()
{
  if (s_instance)
    errorlog << "Should only be one instance of PlayerParam" << ende;
  s_instance = this;
}

PlayerParam::~PlayerParam ()
{
  s_instance = NULL;
}

void
PlayerParam::addAll2Maps ()
{
  ServerParam::addAll2Maps();

  add2Maps("player_types", &player_types);
  add2Maps("pt_max", &pt_max);
  add2Maps("random_seed", &random_seed);
  add2Maps("subs_max", &subs_max);
  add2Maps("dash_power_rate_delta_max", &dash_power_rate_delta_max);
  add2Maps("dash_power_rate_delta_min", &dash_power_rate_delta_min);
  add2Maps("effort_max_delta_factor", &effort_max_delta_factor);
  add2Maps("effort_min_delta_factor", &effort_min_delta_factor);
  add2Maps("extra_stamina_delta_max", &extra_stamina_delta_max);
  add2Maps("extra_stamina_delta_min", &extra_stamina_delta_min);
  add2Maps("inertia_moment_delta_factor", &inertia_moment_delta_factor);
  add2Maps("kick_rand_delta_factor", &kick_rand_delta_factor);
  add2Maps("kickable_margin_delta_max", &kickable_margin_delta_max);
  add2Maps("kickable_margin_delta_min", &kickable_margin_delta_min);
  add2Maps("new_dash_power_rate_delta_max", &new_dash_power_rate_delta_max);
  add2Maps("new_dash_power_rate_delta_min", &new_dash_power_rate_delta_min);
  add2Maps("new_stamina_inc_max_delta_factor", &new_stamina_inc_max_delta_factor);
  add2Maps("player_decay_delta_max", &player_decay_delta_max);
  add2Maps("player_decay_delta_min", &player_decay_delta_min);
  add2Maps("player_size_delta_factor", &player_size_delta_factor);
  add2Maps("player_speed_max_delta_max", &player_speed_max_delta_max);
  add2Maps("player_speed_max_delta_min", &player_speed_max_delta_min);
  add2Maps("stamina_inc_max_delta_factor", &stamina_inc_max_delta_factor);

}

void
PlayerParam::setDefaultValues ()
{
  ServerParam::setDefaultValues();

  player_types = 7;
  pt_max = 3;
  random_seed = -1;
  subs_max = 3;
  dash_power_rate_delta_max = 0;
  dash_power_rate_delta_min = 0;
  effort_max_delta_factor = -0.002;
  effort_min_delta_factor = -0.002;
  extra_stamina_delta_max = 100;
  extra_stamina_delta_min = 0;
  inertia_moment_delta_factor = 25;
  kick_rand_delta_factor = 0.5;
  kickable_margin_delta_max = 0.2;
  kickable_margin_delta_min = 0;
  new_dash_power_rate_delta_max = 0.002;
  new_dash_power_rate_delta_min = 0;
  new_stamina_inc_max_delta_factor = -10000;
  player_decay_delta_max = 0.2;
  player_decay_delta_min = 0;
  player_size_delta_factor = -100;
  player_speed_max_delta_max = 0;
  player_speed_max_delta_min = 0;
  stamina_inc_max_delta_factor = 0;
}

void
PlayerParam::postReadProcessing()
{
  ServerParam::postReadProcessing();
}

