/* -*- Mode: C++ -*- */

#ifndef _ONLINE_RUNNER_H_
#define _ONLINE_RUNNER_H_

#include <iostream>
#include <fstream>
#include <pthread.h>
#include <rcssbase/net/udpsocket.hpp>
#include <rcssbase/net/socketstreambuf.hpp>
#include "Runner.h"
#include "WorldHistory.h"
#include "CoachCommand.h"
#include "OnlineParser.h"
#include "LoggingSocketStreamBuf.h"
#include "PlayerTypeStorage.h"
#include "soccer_utils.h"
#include "CoachTagFunction.h"
#include "utility.h"

/**********************************************************************************/

class OnlineRunner
  : public Runner,
  public TimeTagger
{
public:
  OnlineRunner(ModuleRegistry* pReg);
  ~OnlineRunner();

  // this method should call all of the the dependency check methods of the appropriate
  // type
  bool dependencyCheck(ModuleRegistry* pReg);

  // the method to enter the loop and do all the work
  bool run();

  TeamSide getMySide() const { return my_side; }
  TeamSide getSide(RelativeTeamSide rts) const { return relativeTeamSideToAbs(rts, my_side); }
  const std::string& getLeftTeamName() const { return left_team_name; }
  const std::string& getRightTeamName() const { return right_team_name; }
  //If left and right have not been set, this will set the team name, so you can't ask
  // about arbitrary names
  TeamSide getSideOf(const char* team_name);
  TeamSide determineSide(const char* side_str, const char* team_str)
  { return ::determineSide(side_str, team_str, left_team_name.c_str(), right_team_name.c_str()); }
     
  const WorldHistory& getWorldHistory() const { return history; }
  const PlayerTypeStorage& getPlayerTypeStorage() const { return player_type_storage; }
  
  //does NOT take the memory
  bool sendToServer(const CoachCommand* pCom);

  // this is a cleanup functions which signals that the parser done;
  // it's used so that when the parser thread in cancelled, it notifies the runner
  void cleanupSignalParserDone();

  //This is the time tagger method
  std::string getTime() const
  { return spades::toString(history.getNumAvail() ? history.getWorldState().getTime() : -1); }

protected:
  friend class OnlineParser;

  WorldHistory history;

  void setMySide(TeamSide ts) { my_side = ts; }

  pthread_t thrd_parser;
  pthread_cond_t cv_parser_done;
  pthread_mutex_t mutex_parser_done;
  //the mutex protects this variable
  bool parser_done;

  void prot_initiateShutdown();

private:
  bool initConnection();

  void runParser();
  //the arg should be an OnlineRunner)
  static void* startParser(void* arg);

  void handleParserDone();
  
  rcss::net::Addr server_addr;
  rcss::net::UDPSocket socket;
  std::ofstream send_log;
  std::ofstream recv_log;
  LoggingSocketStreamBuf write_strmbuf;
  LoggingSocketStreamBuf read_strmbuf;

  std::ostream write_strm;
  std::istream read_strm;

  OnlineParser parser;

  PlayerTypeStorage player_type_storage;
  
  TeamSide my_side;

  std::string left_team_name;
  std::string right_team_name;
  
  std::ofstream command_outfile;

  enum RunState {
    RS_Startup,
    RS_Init,
    RS_Running
  } run_state;
};



#endif
