/* -*- Mode: C++ -*- */

/* This is a parser class for commands received when connected online */

#ifndef _ONLINE_PARSER_H_
#define _ONLINE_PARSER_H_

#include <iostream>
#include <rccparser/rccparser.h>
#include "clangmsgbuilder.h"
#include "clangparser.h"
#include "WorldState.h"
#include "ParamReader.h"
#include "PlayerTypeStorage.h"

class OnlineRunner;

/**********************************************************************************/

class OnlineParser
  : public rcc::Parser
{
public:
  enum MsgType  {
    MT_None,
    MT_Init,
    MT_ServerParam,
    MT_PlayerParam,
    MT_PlayerType,
    MT_Visual,
    MT_Error,
    MT_Warning,
    MT_Other
  };

public:
  OnlineParser(OnlineRunner& runner);
  ~OnlineParser();

  MsgType getLastMessageType() const { return last_msg_type; }

  //read the last_*_param structures into the ParamReader below, printing out error if they don't exist
  void storeParamsTo(spades::ParamReader* paramreader);
  void storePlayerTypeTo(PlayerTypeStorage& storage);
  
protected:
  // Called at the end of every parsed message
  void doMsgParsed();

  // Parameter stuff
  void doBuildServerParam();
  void doBuildParam( const std::string& name, int value );
  void doBuildParam( const std::string& name, double value );
  void doBuildParam( const std::string& name, const std::string& value );
  void doBuildPlayerParam();
  void doBuildPlayerType();
  
  // Player identity stuff
  void doBuildTeamName( const std::string& name ) { last_team_name = name; }
  void doBuildUNum( int unum ) { last_unum = unum; }
  void doBuildGoalie() { last_goalie = true; }
  void doBuildLeftSide() { last_side = TS_Left; }
  void doBuildRightSide() { last_side = TS_Right; }
  
  //Init
  void doBuildCoachInit();
  
  //Global visuals
  void doBuildGlobalVisual( int time );
  void doBuildGlobalGoal( double x, double y );
  void doBuildGlobalBall( double x, double y, double delta_x, double delta_y );
  //there are two other variants of doBuildGLobalPlayer that have more info, but I'm
  //letting that be thrown away
  void doBuildGlobalPlayer( double x, double y,
			    double delta_x, double delta_y,
			    double orientation, double head_orientation );

  //playmodes
  void doBuildCatchBallLeftPlayMode(); 
  void doBuildCatchBallRightPlayMode(); 
  void doBuildBeforeKickOffPlayMode(); 
  void doBuildTimeOverPlayMode(); 
  void doBuildPlayOnPlayMode(); 
  void doBuildKickOffLeftPlayMode(); 
  void doBuildKickOffRightPlayMode(); 
  void doBuildKickInLeftPlayMode(); 
  void doBuildKickInRightPlayMode(); 
  void doBuildFreeKickLeftPlayMode(); 
  void doBuildFreeKickRightPlayMode(); 
  void doBuildCornerKickLeftPlayMode(); 
  void doBuildCornerKickRightPlayMode(); 
  void doBuildGoalKickLeftPlayMode(); 
  void doBuildGoalKickRightPlayMode(); 
  void doBuildAfterGoalLeftPlayMode(); 
  void doBuildAfterGoalRightPlayMode(); 
  void doBuildDropBallPlayMode(); 
  void doBuildOffSideLeftPlayMode(); 
  void doBuildOffsideRightPlayMode(); 
  void doBuildPenaltyKickLeftPlayMode(); 
  void doBuildPenaltyKickRightPlayMode(); 
  void doBuildFirstHalfOverPlayMode(); 
  void doBuildPausePlayMode(); 
  void doBuildHumanPlayMode(); 
  void doBuildFoulLeftPlayMode(); 
  void doBuildFoulRightPlayMode(); 
  void doBuildFoulChargeLeftPlayMode(); 
  void doBuildFoulChargeRightPlayMode(); 
  void doBuildFoulPushLeftPlayMode(); 
  void doBuildFoulPushRightPlayMode(); 
  void doBuildFoulMultipleAttackerLeftPlayMode(); 
  void doBuildFoulMultipleAttackerRightPlayMode(); 
  void doBuildFoulBallOutLeftPlayMode(); 
  void doBuildFoulBallOutRightPlayMode(); 
  void doBuildBackPassLeftPlayMode(); 
  void doBuildBackPassRightPlayMode(); 
  void doBuildFreeKickFaultLeftPlayMode(); 
  void doBuildFreeKickFaultRightPlayMode(); 
  void doBuildCatchFaultLeftPlayMode(); 
  void doBuildCatchFaultRightPlayMode(); 
  void doBuildIndirectFreeKickLeftPlayMode(); 
  void doBuildIndirectFreeKickRightPlayMode(); 
  void doBuildPenaltySetupLeftPlaymode(); 
  void doBuildPenaltySetupRightPlaymode(); 
  void doBuildPenaltyReadyLeftPlaymode(); 
  void doBuildPenaltyReadyRightPlaymode(); 
  void doBuildPenaltyTakenLeftPlaymode(); 
  void doBuildPenaltyTakenRightPlaymode(); 
  void doBuildPenaltyMissLeftPlaymode(); 
  void doBuildPenaltyMissRightPlaymode(); 
  void doBuildPenaltyScoreLeftPlaymode(); 
  void doBuildPenaltyScoreRightPlaymode(); 
  void doBuildPenaltyOnFieldLeftPlaymode(); 
  void doBuildPenaltyOnFieldRightPlaymode(); 
  void doBuildPenaltyFoulLeftPlaymode(); 
  void doBuildPenaltyFoulRightPlaymode(); 
  void doBuildPenaltyWinnerLeftPlaymode(); 
  void doBuildPenaltyWinnerRightPlaymode(); 
  void doBuildPenaltyDrawPlaymode(); 
   
  // heard information
  void doBuildGoalRefAudio( int time, int score );
  void doBuildUnknownRefAudio( int time, const std::string& message );
  void doBuildPlayerAudio( int time, const std::string& msg );

  //other stuff
  //SMURF: don't forget the clang version messages

  //errors and warnings
  void doBuildCantReconnect();
  void doBuildInitError();
  void doBuildNoMoreTeamOrPlayerOrGoalieError();
  void doBuildNoSuchTeamOrAlreadyHaveCoachError();
  void doBuildTooManyMovesError();
  void doBuildUnknownCommandError();
  void doBuildIllegalCommandError();
  void doBuildSayMessageTooLongError();
  void doBuildIllegalModeError();
  void doBuildIllegalObjectFormError();
  void doBuildSaidTooManyFreeformMessagesError();
  void doBuildCannotSayFreeformWhilePlayonError();
  void doBuildSaidTooManyMetaMessagesError();
  void doBuildSaidTooManyAdviceMessagesError();
  void doBuildSaidTooManyInfoMessagesError();
  void doBuildSaidTooManyDefineMessagesError();
  void doBuildCouldNotParseSayError();
  void doBuildSaidTooManyMessagesError();
  void doBuildUnknownError( const std::string& error );
  void doBuildNoTeamFoundWarning();
  void doBuildNoSuchPlayerWarning();
  void doBuildCannotSubWhilePlayOnWarning();
  void doBuildNoSubsLeftWarning();
  void doBuildMaxOfThatPlayerTypeOnFieldWarning();
  void doBuildCannotChangeGoalieWarning();
  void doBuildCompressionWarning();
  void doBuildUnknownWarning( const std::string& warning );
  
  
private:
  void clearLastParam();
  //doubles sometimes get parsed as ints, so we have to check both
  double getDoubleParamVal(const char* key);
  
  OnlineRunner& runner;

  MsgType last_msg_type; 
  
  rcss::clang::MsgBuilder clang_builder;
  rcss::clang::Parser clang_parser;

  //storage of vals during parsing
  std::string last_team_name;
  int last_unum;
  bool last_goalie;
  TeamSide last_side;
  typedef std::map<std::string, int> IntParamStorage;
  typedef std::map<std::string, double> DoubleParamStorage;
  typedef std::map<std::string, std::string> StringParamStorage;
  IntParamStorage last_int_param;
  DoubleParamStorage last_double_param;
  StringParamStorage last_string_param;
  
  static const int DIGITS_OF_PRECISION = 6;
};

std::ostream& operator<<(std::ostream& o, OnlineParser::MsgType t);


#endif
