/* -*- Mode: C++ -*- */

/* This class provides a registry for all the modules in the system */

#ifndef _MODULE_REGISTRY_H_
#define _MODULE_REGISTRY_H_
#include "Module.h"

class ModuleRegistry 
{
public:
  ModuleRegistry() {}
  ~ModuleRegistry() { deleteAllModules(); }
  
  void addModule(Module* m);
  bool removeModule(Module* m);
  void deleteAllModules();
  int numModules() { return storage.size(); }
  Module* lookup(const char* name);
  
  //we use a vector because we will perform the various module ops in order of registration
  // this makes lookup slow, but that should only happen a few times
  typedef std::vector<Module*> ModuleStorage;

  ModuleStorage& getStorage() { return storage; }
  const ModuleStorage& getStorage() const { return storage; }

private:
  ModuleStorage storage;
} ;


#endif
