/* -*- Mode: C++ -*- */

/* This class provides a registry for all the modules in the system */

#include "ModuleRegistry.h"
#include "Logger.h"

using namespace spades;

void
ModuleRegistry::addModule(Module* m)
{
  actionlog(10) << "ModuleRegistry: Adding module '" << m->getName() << "'" << ende;
  storage.push_back(m);
}

bool
ModuleRegistry::removeModule(Module* m)
{
  ModuleStorage::iterator i;
  for ( i = storage.begin();
	i != storage.end();
	i++)
    {
      if (*i == m)
	{
	  storage.erase(i);
	  actionlog(10) << "ModuleRegistry: Removing module '" << m->getName() << "'" << ende;
	  return true;
	} 
    }
  errorlog << "ModuleRegistry: Could not find module '" << m->getName() << "' to remove" << ende;
  return false;
}

void
ModuleRegistry::deleteAllModules()
{
  while (!storage.empty())
    {
      delete *storage.begin();
      storage.erase(storage.begin());
    }
}

Module*
ModuleRegistry::lookup(const char* name)
{
  ModuleStorage::iterator i;
  for ( i = storage.begin();
	i != storage.end();
	i++)
    {
      if ((*i)->getName() == std::string(name))
	{
	  return *i;
	} 
    }
  return NULL;
}


