/* -*- Mode: C++ -*- */

#ifndef _MODULE_H_
#define _MODULE_H_

//A module is just something that can receive sight updates

#include "WorldHistory.h"
class Runner;
class SingleCallRunner;
class OnlineRunner;
class LogfileRunner;
class ModuleRegistry;

class Module 
{
public:
  Module(const char* name) : name(name), last_state_update_time(-1) {}
  virtual ~Module() {}

  const std::string& getName() const { return name; }

  // See the protected methods below for what should be defined in each Module
  void stateUpdateOnlineNotify(OnlineRunner& online_runner,
                               const WorldHistory& history);
  void stateUpdateLogfileNotify(LogfileRunner& logfile_runner,
                                const WorldHistory& history);

  virtual void shutdownOnlineNotify(OnlineRunner& online_runner,
                                    const WorldHistory& history) {}
  virtual void shutdownLogfileNotify(LogfileRunner& logfile_runner,
                                     const WorldHistory& history) {}
  
  void singleCall(SingleCallRunner& runner);
  
  //Checks that all inter-module dependencies are satisfied; Called after all
  // modules initialized
  virtual bool dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner) = 0;
  virtual bool dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner) = 0;
  virtual bool dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner) = 0;

  // returns the last time (in the world state) a stateUpdate*Notify method was called
  Time getLastStateUpdateTime() const { return last_state_update_time; }
  
protected:
  //By defualt, the other state update methods simply call this one
  // However, if the module want to do something different based on who
  // is running the show, that can redefine those others
  virtual void protStateUpdateNotify(Runner& runner,
				 const WorldHistory& history) = 0;
  virtual void protStateUpdateOnlineNotify(OnlineRunner& online_runner,
				       const WorldHistory& history);
  virtual void protStateUpdateLogfileNotify(LogfileRunner& logfile_runner,
					const WorldHistory& history);

  virtual void protSingleCall(SingleCallRunner& runner) = 0;
  
  
private:
  std::string name;
  Time last_state_update_time;
} ;



#endif
