/* -*- Mode: C++ -*- */

#include "Module.h"
#include "OnlineRunner.h"
#include "LogfileRunner.h"


void
Module::stateUpdateOnlineNotify(OnlineRunner& online_runner,
				const WorldHistory& history)
{
  last_state_update_time = history.getNumAvail() ? history.getWorldState().getTime() : -1;
  protStateUpdateOnlineNotify(online_runner, history);
}

void
Module::stateUpdateLogfileNotify(LogfileRunner& logfile_runner,
				 const WorldHistory& history)
{
  last_state_update_time = history.getNumAvail() ? history.getWorldState().getTime() : -1;
  protStateUpdateLogfileNotify(logfile_runner, history);
}

  
void
Module::singleCall(SingleCallRunner& runner)
{
  last_state_update_time = -1;
  protSingleCall(runner);
}

  

void
Module::protStateUpdateOnlineNotify(OnlineRunner& online_runner, const WorldHistory& history)
{
  protStateUpdateNotify(online_runner, history);
}

void
Module::protStateUpdateLogfileNotify(LogfileRunner& logfile_runner, const WorldHistory& history)
{
  protStateUpdateNotify(logfile_runner, history);
}
