/* -*- Mode: C++ -*- */

#ifndef _MODTRAINER_H_
#define _MODTRAINER_H_

#include <iostream>
#include <fstream>
#include <vector>
#include "Module.h"
#include "TrainerConnection.h"

class ModTrainer
  : public Module
{
public:
  static void initialize(ModuleRegistry* pReg);
  
public:
  ModTrainer();
  ~ModTrainer();

  void protStateUpdateNotify(Runner& runner, const WorldHistory& history);
  void protStateUpdateOnlineNotify(OnlineRunner& online_runner, const WorldHistory& history);
  void protSingleCall(SingleCallRunner& runner);

  //Checks that all inter-module dependencies are satisfied; Called after all
  // modules initialized
  bool dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner);
  bool dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner);
  bool dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner);

private:
  TrainerConnection conn;
  std::ifstream is_ball_spots;
  
};


#endif
