/* -*- Mode: C++ -*- */

#include "ModTrainer.h"
#include "CoachParam.h"
#include "ModuleRegistry.h"
#include "Logger.h"

using namespace spades;

/**********************************************************************************/  

/* static method */
void
ModTrainer::initialize(ModuleRegistry* pReg)
{
  if (!CoachParam::instance()->getUseModTrainer())
    return;

  pReg->addModule(new ModTrainer());
}

/**********************************************************************************/  
ModTrainer::ModTrainer()
  : Module("Trainer"), conn(), is_ball_spots()
{
}

ModTrainer::~ModTrainer()
{
}

void
ModTrainer::protStateUpdateNotify(Runner& runner, const WorldHistory& history)
{
  errorlog << "ModTrainer: how am I in normal stateUpdate?" << ende;
}

void
ModTrainer::protStateUpdateOnlineNotify(OnlineRunner& online_runner, const WorldHistory& history)
{
  if (history.getWorldState().getTime() %
      CoachParam::instance()->getTrainerDropBallInterval() == 1)
    {
      VecPosition v;
      is_ball_spots >> v;
      if (is_ball_spots.fail())
	errorlog << "ModTrainer: Could not read ball spots from file" << ende;
      //conn.moveBall(VecPosition(10, -30 + 10 * (history.getWorldState().getTime() % 7)));
      conn.moveBall(v);
    }
}

void
ModTrainer::protSingleCall(SingleCallRunner& runner)
{
  std::cout << "ModTrainer: creating file of points" << std::endl;
  std::ofstream os(CoachParam::instance()->getTrainerDropBallSpotsFN().c_str());
  if (!os.good())
    {
      errorlog << "ModTrainer: failed to open drop ball spots file '"
	       << CoachParam::instance()->getTrainerDropBallSpotsFN()
	       << "' " << ende;
      return;
    }

  Rectangle r(VecPosition(-25, -28), VecPosition(25, 28));
  FieldImage fi;
  fi.addFieldLines();
  fi.addRectangle(r, FieldImage::COLOR_DARKGREY, FieldImage::COLOR_CLEAR);
  for (int i=0; i<100; i++)
    {
      VecPosition v = r.getRandomPtIn();
      os << v << std::endl;
      fi.addPoint(v);
    }
  //adds the png
  fi.writeTo(CoachParam::instance()->getTrainerDropBallSpotsFN().c_str());
}


//Checks that all inter-module dependencies are satisfied; Called after all
// modules initialized
bool
ModTrainer::dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner)
{
  if (!conn.initializeConnection())
    {
      errorlog << "ModTrainer: connection failed" << ende;
      return false;
    }
  is_ball_spots.open(CoachParam::instance()->getTrainerDropBallSpotsFN().c_str());
  if (!is_ball_spots)
    {
      errorlog << "ModTrainer: failed to open ball spots file '"
	       << CoachParam::instance()->getTrainerDropBallSpotsFN()
	       << "' " << ende;
      return false;
    }
  
  actionlog(20) << "ModTrainer: here and started" << ende;
  return true;
}
  
bool
ModTrainer::dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner)
{
  return true;
}
  
bool
ModTrainer::dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner)
{
  errorlog << "ModTrainer: Logfile not supported" << ende;
  return false;
}
