
#include <iostream>
#include "ModTest.h"
#include "ModuleRegistry.h"
#include "CoachParam.h"
#include "Logger.h"

using namespace spades;
using namespace std;

void
ModTest::initialize(ModuleRegistry* pReg)
{
  if (!CoachParam::instance()->getUseModTest())
    return;

  pReg->addModule(new ModTest());
}


void
ModTest::protStateUpdateNotify(Runner& runner, const WorldHistory& history)
{
  actionlog(50) << "ModTest: stateUpdateNotify called" << ende;

  if (history.getNumAvail() == 0)
    {
      actionlog(50) << "ModTest: No history states available" << ende;
      return;
    }

  //cout << "ModTest: last call time is " << getLastStateUpdateTime() << endl;
  cout << "ModTest, printing world state: " << endl
       << history.getWorldState() << endl;
}

void
ModTest::protSingleCall(SingleCallRunner& runner)
{
  actionlog(50) << "ModTest: singleCall called" << ende;
  cout << "ModTest, single call" << endl;
}

