/* -*- Mode: C++ -*- */

/* A module that captures and draws various game features */
   
#ifndef _MOD_STAT_IMAGE_H_
#define _MOD_STAT_IMAGE_H_

#include <iostream>
#include <fstream>
#include "Module.h"
#include "FieldImage.h"
#include "data.h"

class ModFeatures;

class ModStatImage
  : public Module
{
public:
  static void initialize(ModuleRegistry* pReg);
  
public:
  ModStatImage();
  ~ModStatImage();

  void protStateUpdateNotify(Runner& runner, const WorldHistory& history);
  void protSingleCall(SingleCallRunner& runner);

  //Checks that all inter-module dependencies are satisfied; Called after all
  // modules initialized
  bool dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner);
  bool dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner) { return true; }
  bool dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner);

private:
  void handleDrawWorldState(const WorldHistory& history);
  void handleDrawBallPath(const WorldHistory& history);
  void saveBallPathImage();
  void handleMiscStats(const WorldHistory& history);
  void doFinalMiscStats();
  
  Time last_time_draw_ws;

  Time last_time_draw_ball_path;
  int ball_path_img_idx;
  FieldImage fi_ball_path;
  Rectangle rec_for_ball_path;
  TeamSide ball_path_owner_side;

  Rectangle rec_for_misc_ball;
  std::ofstream os_for_misc_ball_rec_x;

  ModFeatures* pmFeatures;
  
  SingleDataSummary sds_ball_x;
  SingleDataSummary sds_ball_y;
  SingleDataSummary sds_ball_on_left;
  SingleDataSummary sds_left_ball_owner;
  SingleDataSummary sds_left_control_length;
  SingleDataSummary sds_right_control_length;
  // % of play on cycles that 
  SingleDataSummary sds_left_on_attack;
  SingleDataSummary sds_right_on_attack;
  SingleDataSummary sds_ball_in_rect;
  
  Time this_control_start;
  
};




#endif
