/* -*- Mode: C++ -*- */

#ifndef _MODSETPLAYPLAN_H_
#define _MODSETPLAYPLAN_H_

#include <ostream.h>
#include "Module.h"
#include "CoachMessageQueue.h"
#include "ModCMRep.h"
#include "ModFormation.h"
//#include <TestFunction.h>
#include "PlannerController.h"
#include "OppModelSet.h"
#include "DefOppModel.h"
#include "FourLevelPlanner.h"

class ModSetplayPlan : public Module
{
public:
  static void initialize(ModuleRegistry* pReg);

public:
  ModSetplayPlan();
  virtual ~ModSetplayPlan();

  void protStateUpdateNotify(Runner& runner, const WorldHistory& history);
  void protStateUpdateOnlineNotify(OnlineRunner& online_runner, const WorldHistory& history);
  void protSingleCall(SingleCallRunner& runner);

  //Checks that all inter-module dependencies are satisfied; Called after all
  // modules initialized
  bool dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner);
  bool dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner);
  bool dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner);

  OppModel*    getBestOppModel() { return pOMSet->getBestOM(); }
  OppModelSet* getOMSet() { return pOMSet; }

private:
  bool shouldISetupKickOff(const WorldHistory& history);
  // we have to wait to do most of our intialization until we have a WorldHistory
  // and side of the field stuff figured out
  bool initializeMembers(TeamSide my_side, const WorldHistory& history);

  bool initialized;
  
  PlannerController* planControl;  
  FourLevelPlanner* p4LP;
  Problem* currProb;  
  bool setupKickOff;  
  
  // DEB: set this to be the right type (the virtual base class) for Defensive opp
  // models
  DefOppModel* pDefOM;

  // DEB: here is the variable for the offensive opponent model set;
  // you probably won't have to mess with this
  OppModelSet* pOMSet;
  OppModelSet* pOMSetUniform; /* this is reset to uniform before each update */

  ModCMRep* pCMRep;
  CoachMessageQueue mqueue;

  ModFormation* pmFormation;
  
  /* this next chunk is all test stuff
  TestFunction* tfunc;
  Plan myPlan;  
  int messSegmentsRemaining;
  int messSegmentsSent;  
  char* mess_buf;
  */
  
};


#endif



