/* -*- Mode: C++ -*- */

#include <iostream.h>
#include "ModSetplayPlan.h"
#include "soccer_utils.h"

#include "Monitor.h"
#include "Diagnosis.h"
#include "Planner.h"
#include "Executor.h"
#include "ShareContModules.h"
#include "ContModules.h"
#include "FourLevelPlanner.h"
#include "SharePlannerModules.h"
#include "PlannerModules.h"
#include "opp_models.h"
#include "model_test.h"
#include "CoachParam.h"
#include "ModuleRegistry.h"
#include "OnlineRunner.h"
#include "Logger.h"
using namespace spades;


//#define TEST_PAT
//#define TEST_PAT2
//#define TEST_PAT3

#define OUTPUT(x) 

/**********************************************************************************/  

/* static method */
void
ModSetplayPlan::initialize(ModuleRegistry* pReg)
{
  if (!CoachParam::instance()->getUseModSetplayPlan())
    return;

  pReg->addModule(new ModSetplayPlan());
}

/**********************************************************************************/  

ModSetplayPlan::ModSetplayPlan()
  : Module("SetplayPlan"),
    initialized(false),
    planControl(NULL),
    p4LP(NULL),
    currProb(NULL),
    setupKickOff(false),
    pDefOM(NULL),
    pOMSet(NULL),
    pOMSetUniform(NULL),
    pCMRep(NULL),
    mqueue("SetplayPlan"),
    pmFormation(NULL)
{

}

bool
ModSetplayPlan::initializeMembers(TeamSide my_side, const WorldHistory& history)
{
  if (initialized)
    return true;

  actionlog(100) << "Starting real intialization for ModSetplayPlan" << ende;
  
  // We can't actually do this because WorldHistory is const. I need to think about
  // whether we really want WorldHistory to be const at all
  //  history.ensureStoring(CoachParam::instance()->getSppKickoffFixedPosTime());
  
  //SMURF: how should I handle the default plan?
  planControl = new PlannerController();  
  if (!planControl) {
    errorlog << "planControl did not allocate" << ende;
    return false;
  }

  // DEB: Here is where you allocate your defensive oppoenent model
  if (CoachParam::instance()->getDspUseDefSetPlays())
    pDefOM = new DefOppModel(my_side);
  else
    pDefOM = NULL;
  //DEB: do any intialization of pDefOM here

  pOMSet = new OppModelSet;
  pOMSetUniform = new OppModelSet;
  //DEB: do any initialization of pOMSet (like adding opponent models) here
  //pOMSet->addOM(new OM_Stones, 2.0);
  //SMURF: this is for model testing!
  if (1) {
    pOMSet->addOM(new OM_AllNoMove(.5), 1.0);
    pOMSet->addOM(new OM_AllBall(.5), 1.0);
    pOMSet->addOM(new OM_AllDef(.5), 1.0);
    pOMSet->addOM(new OM_AllOff(.5), 1.0);
    //pOMSet->addOM(new OM_OneBall_NoMove(), 1.0);
    pOMSet->addOM(new OM_OneBallIncr_NoMove(.5), 1.0);
    for (int i=0; i<pOMSet->getNumModels(); i++)
      pOMSetUniform->addOM(pOMSet->getOM(i), 1.0);
    pOMSetUniform->normalize();
  } else {
    pOMSet->addOM(new OM_SpreadingStones(.001), 1.0);
    pOMSet->addOM(new OM_SpreadingStones(.4), 3.0);
    pOMSet->addOM(new OM_NGoToBall(1, .6, .3), 4.0);
    pOMSet->addOM(new OM_NGoToBall(2, .3, .3), 3.0);
    pOMSet->addOM(new OM_NGoToBall(11, .2, .3), 3.0);
    //pOMSet->	addOM(new OM_AlwaysLeft, 1.0);
    //pOMSet->addO	M(new OM_AlwaysRight, 1.0);
  }
  
  pOMSet->normalize();
  OUTPUT(pOMSet->printProbs());
  pOMSet->logProbs(100);

  /* need to have the opp model set monitor before opponent possesion,
     so that we can get that last observation */
  planControl->addMonitor(new OppModelSetMonitor(my_side, history, pOMSet, pOMSetUniform));
  planControl->addMonitor(new OpponentPossessionMonitor(my_side, history));
  if (CoachParam::instance()->getDspUseDefSetPlays())
    planControl->addMonitor(new DefensiveModelMonitor(my_side, history, pDefOM));
  planControl->addMonitor(new TimeoutMonitor(my_side, history));

  planControl->addDiagnosis(new AlwaysFailDiagnosis);
  //planControl->addPlanner(new AlwaysStallPlanner);  

  switch (CoachParam::instance()->getSppPlannerType()) {
  case 0: { //normal
    FourLevelPlanner* planner = new FourLevelPlanner();
    p4LP = planner;

    //planner->setGetPD(new DoNothingGPD);
    //planner->setGetPD(new RandomGPD);
    planner->setGetPD(new GetCurrentGPD(my_side, history));

    //planner->setWaypoint(new DoNothingWP);
    //planner->setWaypoint(new RandomWP);
    HillClimbWP* pHCWP = new HillClimbWP(new PathEvaluator(my_side), my_side, this);
    OUTPUT(pHCWP->PrintStartingPaths(FALSE));
#ifdef OLD_DRAW_STUFF
    if (CoachParam::instance()->getSppDrawWaypoints())
      pHCWP->DrawStartingPaths(CoachParam::instance()->getSppPlansDir());
#endif	
    planner->setWaypoint(pHCWP);

    //planner->setRoleMaker(new DoNothingRM);
    //planner->setRoleMaker(new SimpleAtPointRM);
    //planner->setRoleMaker(new AtPointWithReuseRM);
    planner->setRoleMaker(new OffPointOffsidesRM(my_side));

    //planner->setSTNCompilation(new DoNothingSTNC);
    //planner->setSTNCompilation(new OnlyInitialPosSTNC);
    planner->setSTNCompilation(new FullSTNC);

    //planner->setAgentInstantiation(new DoNothingAI);
    //planner->setAgentInstantiation(new FixedPlanAI);
    //planner->setAgentInstantiation(new JustSpinAI);
 
    if (CoachParam::instance()->getSppPlayersReplaceNums()) 
      errorlog << "We no longer support players doing agent instantiation" << ende;
    planner->setAgentInstantiation(new SequentialAI(1));

    planner->setTimeLimit(CoachParam::instance()->getSppMaxCoachWait()-2, CoachParam::instance()->getSppCoachWaitBuffer());  
    //SMURF: this is not the real time limit!
    //planner->setTimeLimit(2, 0);  
    planControl->addPlanner(planner);

    if (CoachParam::instance()->getDspUseDefSetPlays())
      planControl->addPlanner(new DefensivePlanner(my_side, history, pDefOM));

    //the default plans in case the other levels fail
    planControl->addPlanner(new DefaultPlanPlanner(my_side, history));
  } break;
  
  case 1:
    planControl->addPlanner(new FixedPlanPlanner(my_side, history)); 
    break;

  case 2:
    planControl->addPlanner(new DefaultPlanPlanner(my_side, history));
    break;

  case 3:
    planControl->addPlanner(new DefensivePlanner(my_side, history, pDefOM));
    break;

  default:
    errorlog << "What is CoachParam::instance()->getSpp_planner_type? "
	     << CoachParam::instance()->getSppPlannerType() << ende;
    return false;
    break;
  }

  planControl->addExecutor(new StandardLanguageExecutor(pmFormation,
							my_side,
							history,
							mqueue));
  //planControl->addExecutor(new SayPlanExecutor);
  //planControl->addExecutor(new SayAlwaysExecutor);

  //We don't want plan execution to do a ResetOnLoad because it does the AllPairs
  //closure of the STN plan, making it much larger
  PlanExecution* pe = planControl->getPlanExec();
  if (pe == NULL)
    {
      errorlog << "Why doesn't planControl have a valid PlanExecution?" << ende;
      return false;
    }
  else
    {
      pe->SetResetOnLoad(FALSE);
      pe->StandardLanguageSetup(&mqueue);
    }

  currProb = new Problem();
  if (!currProb) {
    errorlog << "currProb did not allocate" << ende;
    return false;
  }

  // This is for a big hack for the opponent models to let them know what side we are on
  setModelTestSide(my_side);
  
  setupKickOff = false;  

  /*from here on, it's test stuff
  if ((tfunc = new TestFunction) == NULL)
    return FALSE;

  ifstream infile("Plans/test4");
  if (!myPlan.Read(infile)) {
    errorlog << "plan read failed" << ende;
    return FALSE;    
  }
  messSegmentsRemaining = 0;  
  messSegmentsSent = 0;  
  */

  initialized = true;

  return true;
}

ModSetplayPlan::~ModSetplayPlan()
{
  if (pCMRep)
    pCMRep->removeCMQ(&mqueue);

  if (initialized)
    {
      /* delete pDefOM; pfr 7/31/01 This will get deleted my the DefensivePlanner */
      pOMSetUniform->forgetAll();
      delete pOMSet;
      delete pOMSetUniform;
      //pfr 3/3/2004: planControl could have a reference to currProb. Let's just make sure
      // that it doesn't
      planControl->forgetProblem();
      delete planControl;
      delete currProb;
    }
}


//Checks that all inter-module dependencies are satisfied; Called after all
// modules initialized
bool
ModSetplayPlan::dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner)
{
  pCMRep = (ModCMRep*)pReg->lookup("CMRep");
  if (pCMRep == NULL)
    {
      errorlog << "ModSetplayPlan needs ModCMRep" << ende;
      return false;
    }

  pCMRep->addCMQ(&mqueue);

  pmFormation = (ModFormation*)pReg->lookup("Formation");
  if (pmFormation == NULL)
    {
      errorlog << "ModSetplayPlan needs ModFormation" << ende;
      return false;
    }

  return true;
}
  
bool
ModSetplayPlan::dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner)
{
  return true;
}

bool
ModSetplayPlan::dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner)
{
  errorlog << "ModSetplayPlan: Logfile not supported yet" << ende;
  return false;
}
  
void
ModSetplayPlan::protStateUpdateNotify(Runner& runner, const WorldHistory& history)
{
  errorlog << "ModSetplayPlan: Base stateUpdateNotify should not be called" << ende;
}

#define SIDE_SELECT(left_val, right_val) ((online_runner.getMySide()==TS_Left) ? (left_val) : (right_val))

void
ModSetplayPlan::protStateUpdateOnlineNotify(OnlineRunner& online_runner, const WorldHistory& history)
{

  if (!initializeMembers(online_runner.getMySide(), history))
    {
      errorlog << "ModSetplayPlan: failed initialization" << ende;
      return;
    }

  // we do this so that the plan control has less thread issues
  planControl->getPlanExec()->setCurrentTime(history.getWorldState().getTime());
  
#ifdef TEST_PAT
  if (history.getWorldState().getTime() == 1) {
    tfunc->StartAsyncRun();
  }

  if (history.getWorldState().getTime() % 100 == 15) {
    tfunc->GiveMoreData();    
  }
  

  char time_str[10];
  sprintf(time_str, "%d", history.getWorldState().getTime());
  
  tfunc->PrintThrdStatus(time_str);
#endif


#ifdef TEST_PAT2

  /*
  printf("myside: %d\n", Mem->MySide); 
  printf("teams: '%s' '%s'\n", MP_left_team_name, MP_right_team_name);
  */

  printf("%d: Pass ball time : %d\n", history.getWorldState().getTime(),
	 CyclesForBallToPoint(Vector(0,0), 1.0, 2.2, 
			      history.getWorldState().getBall().getPos(),
			      ServerParam::instance()->getSPBallDecay()));
  printf("%d: Send ball time : %d\n", history.getWorldState().getTime(),
	 CyclesForBallToPoint(Vector(0,0),
			      ServerParam::instance()->getSPBallSpeedMax(),
			      2.9, 
			      history.getWorldState().getBall()->getPos(),
			      ServerParam::instance()->getSPBallDecay()));

#endif

#ifdef TEST_PAT3


  //SMURF: this is not the right check: could go directly to free_kick
  if (history.getWorldState().getPlayMode() != history.getWorldState(1).getPlayMode() &&
      history.getWorldState(1).getPlayMode() == PM_PlayOn) {
    printf("Initializing communication %d\n", history.getWorldState().getTime());    
    mess_buf = myPlan.PrintStrCompact();    
    messSegmentsRemaining = (strlen(mess_buf)/ServerParam::instance()->getSPSayCoachMsgSize())+1;
    messSegmentsSent = 0;    
    *(mess_buf-1) = '0'+messSegmentsRemaining;    
    printf("Complete mess: '%s'\n", mess_buf-1);    
  }
  
  if (messSegmentsRemaining > 0) {
    //send a message!
    //the first char starts 1 before the beginning of mess_buf
    char *start, *end, ch;
    start = mess_buf + (messSegmentsSent*ServerParam::instance()->getSPSayCoachMsgSize() - 1);
    end = start + ServerParam::instance()->getSPSayCoachMsgSize();
    ch = *end;
    *end = 0;
    
    printf("Said message %d of %d\n", messSegmentsSent+1, 
	   messSegmentsSent+messSegmentsRemaining);
    
    Say(start);
    
    *end = ch;

    messSegmentsRemaining--;
    messSegmentsSent++;    
  }
  
  return;

#endif

  if (history.getNumAvail() <= 1)
    {
      actionlog(100) << "ModSetplayPlan: waiting for more than one cycle to be available" << ende;
      return;
    }
  

  if (history.getWorldState().getPlayMode() == PM_PlayOn) {
    setupKickOff = FALSE;  
    if (history.getWorldState(2).getPlayMode() != PM_PlayOn) {
      //abort the 4LP planner (usually it should be done, but just in case)
      if (p4LP) {
	actionlog(60) << "Sending abort to 4LP" << ende;
	p4LP->run(NULL, NULL);
      }
    }
  }

  
  //handle cases where we go kick off to kick off
  if ((history.getWorldState().getTime() == ServerParam::instance()->getSPHalfCycles() ||
       history.getWorldState().getTime() == 2*ServerParam::instance()->getSPHalfCycles()) &&
      history.getWorldState().getTime() != history.getWorldState(1).getTime() &&
      history.getWorldState(1).getPlayMode() != PM_PlayOn) {
    actionlog(20) << "There was a kickoff to kickoff transition" << ende;
    //this sends an abort message to the 4LP
    if (p4LP) 
      p4LP->run(NULL, NULL);
    setupKickOff = FALSE;
  }
  
  if (history.getWorldState().getPlayMode() == PM_BeforeKickOff &&
      history.getWorldState(1).getPlayMode() == PM_PlayOn) {
    actionlog(20) << "We just got to half time or end of tied game" << ende;    
    planControl->forgetProblem();
    planControl->initDefaultPlan();
    planControl->setRePlanFlag(FALSE);    
  }

  bool newProblem = false;  
  actionlog(10) << "SetPlayPlan, play_mode=" << history.getWorldState().getPlayMode() << ende;  
  //cout << "time: " << GetTime() << "\tball at: " << GetBall()->pos << endl;
  //SMURF: what if we go right to free_kick for some reason?
  if (shouldISetupKickOff(history)) {
    actionlog(20) << "SetPlayPlan, setting up kick off" << ende;    
    currProb->ball_pos = VecPosition(0,0); //kick off from mid of field
    //it's time to setup the kick off
    switch (history.getWorldState().getPlayMode()) {
      //SMURF BUG: SPHalfCycles can be wrong when slow_down_factor is greater than 1
      // and we receive parameters from the server
    case PM_BeforeKickOff:
      if (history.getWorldState().getTime() < ServerParam::instance()->getSPHalfCycles()) //first half kick off
	currProb->mode = SIDE_SELECT(SPM_My_Kick_Off, SPM_Their_Kick_Off);      
      else if (history.getWorldState().getTime() >= ServerParam::instance()->getSPHalfCycles() &&
	       history.getWorldState().getTime() < 2*ServerParam::instance()->getSPHalfCycles()) //second half kick off
	currProb->mode = SIDE_SELECT(SPM_Their_Kick_Off, SPM_My_Kick_Off);
      else if (history.getWorldState().getTime() >= 2*ServerParam::instance()->getSPHalfCycles())
	currProb->mode = SIDE_SELECT(SPM_My_Kick_Off, SPM_Their_Kick_Off);      
      else
	errorlog << "Why am I here? "
		 << ServerParam::instance()->getSPHalfCycles() << " "
		 << CyclesRemaining(history.getWorldState().getTime()) << " "
		 << CyclesRemainingHalf(history.getWorldState().getTime())
		 << ende;
      break;
    case PM_KickOff_Left:
      currProb->mode = SIDE_SELECT(SPM_My_Kick_Off, SPM_Their_Kick_Off);
      break;
    case PM_KickOff_Right:
      currProb->mode = SIDE_SELECT(SPM_Their_Kick_Off, SPM_My_Kick_Off);
      break;
    case PM_AfterGoal_Left:
      currProb->mode = SIDE_SELECT(SPM_Their_Kick_Off, SPM_My_Kick_Off);
      break;      
    case PM_AfterGoal_Right:
      currProb->mode = SIDE_SELECT(SPM_My_Kick_Off, SPM_Their_Kick_Off);
      break;      
    default:
      errorlog << "What mode is this (handling before kick off) "
	       << history.getWorldState().getPlayMode() << ende;
    }
    
    newProblem = setupKickOff = (currProb->mode != SPM_No_Mode);
  } else if ( history.getWorldState().getPlayMode() != PM_PlayOn && 
	      history.getWorldState(1).getPlayMode() != history.getWorldState().getPlayMode()) {

    actionlog(150) << "About to set up problem: "
		   << history.getWorldState().getPlayMode() << " " 
		   << history.getWorldState(1).getPlayMode() << " "
		   << history.getLastGoalieCatchTime() << ende;
    
    
    //make sure this isn't a kickoff (which is handled above or
    //the offside->free kick transition
    if (history.getWorldState().getPlayMode() != PM_BeforeKickOff &&
	history.getWorldState().getPlayMode() != PM_KickOff_Left &&
	history.getWorldState().getPlayMode() != PM_KickOff_Right &&
	history.getWorldState().getPlayMode() != PM_AfterGoal_Left &&
	history.getWorldState().getPlayMode() != PM_AfterGoal_Right &&
	!isPenaltyKickMode(history.getWorldState().getPlayMode()) &&
	!((history.getWorldState().getPlayMode() == PM_FreeKick_Left && 
	   history.getWorldState(1).getPlayMode()==PM_OffSide_Right) ||
	  (history.getWorldState().getPlayMode() == PM_FreeKick_Right && 
	   history.getWorldState(1).getPlayMode()==PM_OffSide_Left))) {

      actionlog(150) << "setting up prob" << ende;

      //time to package up a problem and send it off to the controller
      currProb->ball_pos = history.getWorldState().getBall().getPos();
      currProb->mode = SPM_No_Mode;    
      currProb->time = history.getWorldState().getTime();
      currProb->fresh = TRUE;      
      switch (history.getWorldState().getPlayMode()) {

      case PM_BeforeKickOff: 
	//already handled this above
	break;

      case PM_KickOff_Left:
      case PM_KickOff_Right:
	errorlog << "I shouldn't be here trying to set up problems in Kick_Off_* mode" << ende;
	break;
      case PM_AfterGoal_Left:
      case PM_AfterGoal_Right:
	errorlog << "I shouldn't be here trying to set up problems here in After_Goal_* mode" << ende;
	break;      
      
	//these might actually be goalie catches, we have to check
      case PM_FreeKick_Left:
      case PM_IndFreeKick_Left:
	if (abs(history.getWorldState().getTime()-history.getLastGoalieCatchTime()) < 2)
	  currProb->mode = SIDE_SELECT(SPM_My_Goalie_Catch, SPM_Their_Goalie_Catch);
	else
	  currProb->mode = SIDE_SELECT(SPM_My_Free_Kick, SPM_Their_Free_Kick);
	break;      
      case PM_FreeKick_Right:
      case PM_IndFreeKick_Right:
	if (abs(history.getWorldState().getTime()-history.getLastGoalieCatchTime()) < 2)
	  currProb->mode = SIDE_SELECT(SPM_Their_Goalie_Catch, SPM_My_Goalie_Catch);
	else
	  currProb->mode = SIDE_SELECT(SPM_Their_Free_Kick, SPM_My_Free_Kick);
	break;      

      case PM_KickIn_Left:
	currProb->mode = SIDE_SELECT(SPM_My_Kick_In, SPM_Their_Kick_In);
	break;      
      case PM_KickIn_Right:
	currProb->mode = SIDE_SELECT(SPM_Their_Kick_In, SPM_My_Kick_In);
	break;      
      case PM_CornerKick_Left:
	currProb->mode = SIDE_SELECT(SPM_My_Corner_Kick, SPM_Their_Corner_Kick);
	break;      
      case PM_CornerKick_Right:
	currProb->mode = SIDE_SELECT(SPM_Their_Corner_Kick, SPM_My_Corner_Kick);
	break;      
      case PM_GoalKick_Left:
	currProb->ball_pos = VecPosition(-ServerParam::instance()->getSPPitchLength()/2.0 + ServerParam::instance()->getSPGoalAreaLength(),
				    signf(history.getWorldState().getBall().getPos().getY())*ServerParam::instance()->getSPGoalAreaWidth()/2);
	currProb->mode = SIDE_SELECT(SPM_My_Goal_Kick, SPM_Their_Goal_Kick);
	break;      
      case PM_GoalKick_Right:
	currProb->ball_pos = VecPosition(ServerParam::instance()->getSPPitchLength()/2.0 - ServerParam::instance()->getSPGoalAreaLength(),
				    signf(history.getWorldState().getBall().getPos().getY())*ServerParam::instance()->getSPGoalAreaWidth()/2);
	currProb->mode = SIDE_SELECT(SPM_Their_Goal_Kick, SPM_My_Goal_Kick);
	break;      
      case PM_OffSide_Left:
      case PM_CatchFault_Left:
      case PM_Back_Pass_Left:
      case PM_Free_Kick_Fault_Left:
	currProb->mode = SIDE_SELECT(SPM_Their_Free_Kick, SPM_My_Free_Kick);
	break;      
      case PM_OffSide_Right:
      case PM_CatchFault_Right:
      case PM_Back_Pass_Right:
      case PM_Free_Kick_Fault_Right:
	currProb->mode = SIDE_SELECT(SPM_My_Free_Kick, SPM_Their_Free_Kick);
	break;      

      case PM_TimeOver:
	//errorlog << "I don't know what to do on time_over" << ende;
	break;

      case PM_Drop_Ball:
	break;      

      default:
	errorlog << "What play mode am I in: " << history.getWorldState().getPlayMode() << ende;
	break;
      }

      newProblem = (currProb->mode != SPM_No_Mode);
    }
    
  } //package up a problem

  if (newProblem) {
    //      errorlog << "Could not identify what to do with mode: %d", history.getWorldState().getPlayMode() << ende;
    //} else {
    currProb->SetSpecMode(online_runner.getMySide() == TS_Left);
    planControl->forgetProblem();      
    planControl->setProblem(currProb);
    planControl->setRePlanFlag(TRUE);      
    actionlog(20) << "set up problem of type: " << currProb->mode << ende;  
    planControl->getPlanExec()->StandardLanguageStartPlan(&mqueue);
  }
  
  switch (planControl->run()) {
  case PCR_Normal:
    break;
    
  case PCR_Complete:
  case PCR_Error:
  case PCR_Abort:
    actionlog(20) << "Tidying up current plan and going to default" << ende;    
    planControl->getPlanExec()->StandardLanguageDeleteAll(&mqueue);
    planControl->forgetProblem();
    planControl->initDefaultPlan();
    planControl->setRePlanFlag(FALSE);
    break;
    
  default:
    errorlog << "What is planControl returning?" << ende;
  }
}

void
ModSetplayPlan::protSingleCall(SingleCallRunner& runner)
{
  if (CoachParam::instance()->getSppDrawWaypoints())
    {
      actionlog(50) << "ModSetplayPlan: Drawing the starting paths" << ende;
      HillClimbWP hcwp(new PathEvaluator(TS_Left), TS_Left, this);
      hcwp.DrawStartingPaths(CoachParam::instance()->getSppPlansDir().c_str());
    }
  else
    {
      actionlog(50) << "ModSetplayPlan: I don't have anything to do for SingleCallRunner" << ende;
    }
}


bool
ModSetplayPlan::shouldISetupKickOff(const WorldHistory& history)
{
  if (setupKickOff)
    return false; //I already set up the kick off
  
  if (history.getWorldState().getPlayMode() == PM_KickOff_Left ||
      history.getWorldState().getPlayMode() ==  PM_KickOff_Right)
    return true; //if get to kickoff, we should definately set up

  if (history.getWorldState().getPlayMode() != PM_BeforeKickOff &&
      history.getWorldState().getPlayMode() != PM_AfterGoal_Left &&
      history.getWorldState().getPlayMode() != PM_AfterGoal_Right)
    return false; //can't set up kick off in any other modes!

  /* now let's check to make sure that all the players are there and haven't
     moved recently */
  if (history.getNumAvail() <= CoachParam::instance()->getSppKickoffFixedPosTime())
    {
      actionlog(150) << "ModSetplayPlan: shouldISetupKickOff: waiting for more cycles" << ende;
      return false;
    }
  
  for (int num=0; num < ServerParam::instance()->getSPTeamSize()*2; num++) {
    const PlayerInfo* player = history.getWorldState().getPlayer(num);
    if (player == NULL)
      return false; //not all their players have connected
    const PlayerInfo* prevplayer = 
      history.getWorldState(CoachParam::instance()->getSppKickoffFixedPosTime()).getPlayer(num);    
    if (prevplayer == NULL || player->getPos() != prevplayer->getPos())
      return false; //this player moved recently or just came on
  }
  
  return true;
}

