/* -*- Mode: C++ -*- */

#ifndef _MODFORMATION_H_
#define _MODFORMATION_H_

#include <iostream>
#include <fstream>
#include <vector>
#include "Module.h"
#include "CoachMessageQueue.h"
#include "data.h"
#include "ModCMRep.h"
#include "ModGlobalAdapt.h"
#include "Formation.h"
#include "FormationLearner.h"
#include "FileReader.h"

class ModFormation
  : public Module, public AdaptationUnit
{
public:
  static void initialize(ModuleRegistry* pReg);
  
public:
  ModFormation();
  ~ModFormation();

  void protStateUpdateNotify(Runner& runner, const WorldHistory& history);
  void protStateUpdateOnlineNotify(OnlineRunner& online_runner, const WorldHistory& history);
  void protStateUpdateLogfileNotify(LogfileRunner& logfile_runner, const WorldHistory& history);
  void protSingleCall(SingleCallRunner& runner);

  //Checks that all inter-module dependencies are satisfied; Called after all
  // modules initialized
  bool dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner);
  bool dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner);
  bool dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner);

  const Formation* getCurrentFormation() const;
  void printFormations(std::ostream& o);
  
  typedef std::list<Formation> FormationStorage;

  //these implement the AdaptationUnit interface
  const char* getAdaptationUnitName() { return "Formation"; }
  int getNumStrategiesForStyle(AdaptStyle style);
  void changeStrategy(const StrategySpec& oldspec, const StrategySpec& newspec);
  
private:
  void initializeFormationFormatters();
  void readFormations();
  void sendAllFormations();
  void pickFormation(bool send);
  void changeToFormation(FormationStorage::iterator iter_new_form, bool send);
  void drawFormations(const std::string& out_dir);

  ModGlobalAdapt* pGlobalAdapt;
  
  ModCMRep* pCMRep;
  FormationLearner learner;

  FormationStorage list_form;
  FormationStorage::iterator iter_curr_form;
  
  CoachMessageQueue mqueue;
  std::ofstream out_gather_data;

  Formation form_opponent;
  bool form_opponent_valid;

  bool sent_formations;
  bool need_to_assign_marks;

  std::vector<FormationFormatter*> vformatter;
};


class FormationFileListReader
  : public spades::FileReader
{
public:
  FormationFileListReader(ModFormation::FormationStorage& storage)
    : FileReader(), storage(storage), count(0) {}
  ~FormationFileListReader() {}

  int getCount() const { return count; }
  void resetCount() { count = 0; }
  
protected:
  // The fileid is to be printed in front of error messages and stuff
  // The path is the full path of the file
  // the version is the version of this file
  bool processLine(std::istrstream& line,
		   const char* fileid,
		   const char* path,
		   float version);

  
private:
  ModFormation::FormationStorage& storage;
  int count;
};



#endif
