/* -*- Mode: C++ -*- */

#ifndef _MODFEATURES_H_
#define _MODFEATURES_H_

/* This file contains various features of the world state that may require
   some history to be stored. The values will be updated on every call
   stateUpdateNotify */
#include <vector>
#include <fstream>
#include "types.h"
#include "Module.h"

using namespace std;

class PlayerID
{
public:
  PlayerID(TeamSide s = TS_None, Unum n = 0) { side = s; num = n; }
  TeamSide side;
  Unum     num;
  friend ostream& operator <<(ostream & os, const PlayerID& p)
  { return os << "[side="<<p.side<<",num="<<p.num<<"]"; }
};

class ModFeatures : public Module
{
 public:
  static void initialize(ModuleRegistry* pReg);

 public:
  ModFeatures();
  ~ModFeatures();

  void protStateUpdateNotify(Runner& runner, const WorldHistory& history);
  void protSingleCall(SingleCallRunner& runner);

  //Checks that all inter-module dependencies are satisfied; Called after all
  // modules initialized
  bool dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner) { return true; }
  bool dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner) { return true; }
  bool dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner) { return true; }

  // 
  const vector<PlayerID>& getBallPossessors() { return getPrevBallPossessors(0); }
  const vector<PlayerID>& getPrevBallPossessors(int cycles_back = 1);
  
  //num is only valid if team is TS_Left or TS_Right
  PlayerID getBallOwner() { return getPrevBallOwner(0); }
  PlayerID getPrevBallOwner(int cycles_back = 1);
  
 private:

  void setBallPossessors(const WorldState& ws);
  void setBallOwner(const WorldState& ws);

  void logBallPossessors(const WorldState& ws);
  void logBallOwner(const WorldState& ws);
  
  int curr_idx_ball_owner;
  PlayerID *aBallOwner;
  std::ofstream os_ball_owner_log;
  
  int curr_idx_ball_poss;
  vector<PlayerID> *avBallPossess;
  std::ofstream os_ball_possess_log;
} ;

#endif
