/* -*- Mode: C++ -*- */

/* A Module for a repository of coach messages. Manages all in and out messages */

#ifndef _MOD_CMREP_H_
#define _MOD_CMREP_H_

#include "Module.h"
#include "CoachMessageQueue.h"

class ModCMRep
  : public Module
{
public:
  static void initialize(ModuleRegistry* pReg);
  
public:
  ModCMRep();
  ~ModCMRep();

  void protStateUpdateNotify(Runner& runner, const WorldHistory& history);
  void protStateUpdateOnlineNotify(OnlineRunner& online_runner, const WorldHistory& history);
  void protSingleCall(SingleCallRunner& runner);

  //Checks that all inter-module dependencies are satisfied; Called after all
  // modules initialized
  bool dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner) { return true; }
  bool dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner) { return true; }
  bool dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner);

  //all modules that want to send coach messages shoudl register here
  // The CMRep does NOT take over the memory
  void addCMQ(CoachMessageQueue* p);
  bool removeCMQ(CoachMessageQueue* p);
  int  numCMQ() { return vCMQ.size(); }

private:
  void queueInitMessages();

  template <class X>
  std::vector<X>
  getElements(int max_size,
	      std::unary_function<CoachMessageQueue*, CoachMessageQueue::ComponentContainer<X>&> &extractor,
	      bool* pitems_remain);
						
  void handleMessageQueues(OnlineRunner& online_runner);

  typedef std::vector<CoachMessageQueue*> CoachMessageQueueStorage;
  CoachMessageQueueStorage vCMQ;

  // elements and functions maintaining counts of when we can send messages
  int define_messages_left;
  int rule_messages_left;
  int del_messages_left;
  Time msg_left_update_time;
  int freeform_messages_left; //how many message have left
  Time last_ff_mess_update_time; //last time we incremented
  int init_delay;
  
  int messages_sent;

  bool did_say_last_cycle;
  
  bool updateMessagesLeft(int time);
  bool canISayFreeform(const WorldHistory& history);
  bool canISayClang(const WorldHistory& history, int msg_window_cnt);
  void decrClangWinCnt(const WorldHistory& history, int* p_msg_window_cnt);  
  
  CoachMessageQueue init_messages_queue;

private:
  //Now some code; templates like to be in the .h files
  template <class X, class _Function>
  std::list<X*>
  getElements(int max_size,
	      _Function extractor,
	      bool* pitems_remain)
  {
    std::list<X*> out;
    int chars_used = 0;
    CoachMessageQueueStorage::iterator cmqiter;

    *pitems_remain = false;

    for(cmqiter = vCMQ.begin();
	cmqiter != vCMQ.end();
	++cmqiter)
      {
	CoachMessageQueue::ComponentContainer<X>& refCont = extractor(*cmqiter);
	X* next;
	while ( (next=refCont.peek()) != NULL )
	  {
	    std::ostrstream tmp_out_str;
	    tmp_out_str << *next << ends;
	    if (tmp_out_str.pcount() + chars_used > max_size)
	      {
		//overflow!
		*pitems_remain = true;
		return out;
	      }
	    else
	      {
		out.push_back(next);
		chars_used += tmp_out_str.pcount();
		refCont.pop();
	      }
	  }
      
      }
    
    return out;
  
  }

};





#endif
