/* -*- Mode: C++ -*- */

#ifndef _MODABSTRACT_H_
#define _MODABSTRACT_H_

#include <iostream>
#include <fstream>
#include <vector>
#include "Module.h"
#include "PlayerOccupancy.h"
#include "AbstractState.h"
#include "CoachMessageQueue.h"
#include "SoccerModelWValue.h"
#include "ABMDP.h"
#include "ModGlobalAdapt.h"

class ModFeatures;
class ModCMRep;

class ModAbstract
  : public Module,
    public AdaptationUnit
{
public:
  static void initialize(ModuleRegistry* pReg);
  
public:
  ModAbstract();
  ~ModAbstract();

  void protStateUpdateNotify(Runner& runner, const WorldHistory& history);
  void protStateUpdateOnlineNotify(OnlineRunner& online_runner, const WorldHistory& history);
  void protStateUpdateLogfileNotify(LogfileRunner& logfile_runner, const WorldHistory& history);
  void protSingleCall(SingleCallRunner& runner);

  //Checks that all inter-module dependencies are satisfied; Called after all
  // modules initialized
  bool dependencyCheck(ModuleRegistry* pReg, OnlineRunner& runner);
  bool dependencyCheck(ModuleRegistry* pReg, SingleCallRunner& runner);
  bool dependencyCheck(ModuleRegistry* pReg, LogfileRunner& runner);

  const char* getAdaptationUnitName() { return "Abstract"; }
  int getNumStrategiesForStyle(AdaptStyle style);
  void changeStrategy(const StrategySpec& oldspec, const StrategySpec& newspec);

private:
  void initializeSoccerModel();
  AbstractStateFactor* createAbstractStateTree(int num_xbins, int num_ybins, const char* poset_fn);
  void initializeStateDescription();
  void initializeAbstractStateTrackers(TeamSide my_side);
  void initializeMultiABMDP();
  
  void initializeAdviceByMDP();
  void initAdviceByMDPFilters(float percent_optimal, bool choose_worst);
  void queueAdviceByMDPFlat();
  void queueAdviceByMDPTree();
  void initAdviceByMDPTree();

  void clearABMDPFilters();
  
  void handlePOTracker(TeamSide my_side, const WorldState& ws);
  void handleAbstractStateTracker(TeamSide my_side, const WorldState& ws);
  void handleAdviceByMDP(TeamSide my_side, const WorldHistory& history);
  void handleTrackAdvisedActions(TeamSide my_side, const WorldState& state);
  
  //things called from single call
  void drawPOSet();
  void learnMarkovChain();
  void learnMarkovChainValue(SingleCallRunner& runner);
  void pruneMarkovChain();
  void createMarkovChainGraph();
  void calcMarkovChainDist();
  void drawAbstractStates(SingleCallRunner& runner);
  void drawAbstractState(int state_num, const char* fn);
  void classifyMC();
  void convertMCToMDP();
  void solveMDP(SingleCallRunner& runner);
  void showMDPState();
  void analyzeQTable();
  void compareStateTraceToModel();
  void computeAverageReward();
  void analyzeMDP();
  void generateMDPStateTraces();
  void convertToBinary();
  void analyzePercentOpt();
  
  PlayerOccupancyTracker *ppotracker;

  ModFeatures* pmFeatures;
  ModCMRep* pmCMRep;
  ModGlobalAdapt* pmGlobalAdapt;
  
  CoachMessageQueue mqueue;
  
  AbstractStateDescription state_description;
  AbstractState curr_abs_state;

  typedef std::vector<AbstractStateTracker*> TrackerStorage;
  bool abstract_state_tracker_init;
  TrackerStorage abstract_state_trackers;

  bool advice_by_mdp_init;
  bool advice_by_mdp_init_filters;
  SoccerModelWValue soccer_model;
  AdviceTree* p_advice_tree;
  std::ofstream out_abmdp_track;
  std::list<SoccerStateFilter*> abmdp_lfilters_state;
  std::list<SoccerActionFilter*> abmdp_lfilters_act;

  std::ofstream os_track_advised;

  typedef std::vector<ABMDP*> MultiABMDPStorage;
  MultiABMDPStorage v_multi_abmdp;
  
  static const char* ADVICE_TREE_RULE_NAME;
  static const char* ADVICE_TREE_MULTI_RULE_PREFIX;
  
};



#endif
