/* -*- Mode: C++ -*- */

/* This class provides a SocketStreamBuf that logs the data send to and from the socket */

#ifndef _LOGGING_SOCKET_STREAM_BUF_H_
#define _LOGGING_SOCKET_STREAM_BUF_H_

#include <rcssbase/net/socketstreambuf.hpp>

class LoggingSocketStreamBuf : public rcss::net::SocketStreamBuf
{
public:
  LoggingSocketStreamBuf(std::ostream& out_log,
			 rcss::net::Socket& socket,
			 const rcss::net::Addr& dest,
			 rcss::net::SocketStreamBuf::ConnType conn = rcss::net::SocketStreamBuf::CONN_ON_READ, 
			 std::streamsize bufsize = 8192)
    : SocketStreamBuf(socket, dest, CONN_ON_READ, bufsize), out_log(out_log)
  {}
protected:
  bool writeData()
  {
    int size = (pptr() - pbase()) * sizeof(char_type);
    out_log << "Send: ";
    out_log.write(pbase(), size);
    out_log << std::endl;
    return rcss::net::SocketStreamBuf::writeData();
  }
  int_type underflow()
  {
    int_type retval = rcss::net::SocketStreamBuf::underflow();
    out_log << "Recv: ";
    out_log.write(eback(), egptr()-eback());
    out_log << std::endl;
    return retval;
  }
  
private:
  std::ostream& out_log;
};


#endif	
